/*
 * Decompiled with CFR 0.152.
 */
package relcontext;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import relcontext.ChosenRelationListener;

public class ChosenRelation
implements MapView.EditLayerChangeListener,
MapViewPaintable,
DataSetListener {
    protected Relation chosenRelation = null;
    private Set<ChosenRelationListener> chosenRelationListeners = new HashSet<ChosenRelationListener>();
    private static final String[] MULTIPOLYGON_TYPES = new String[]{"multipolygon", "boundary"};

    public void set(Relation rel) {
        if (rel == this.chosenRelation || rel != null && this.chosenRelation != null && rel.equals((Object)this.chosenRelation)) {
            return;
        }
        Relation oldRel = this.chosenRelation;
        this.chosenRelation = rel;
        this.analyse();
        Main.map.mapView.repaint();
        this.fireRelationChanged(oldRel);
    }

    protected void fireRelationChanged(Relation oldRel) {
        for (ChosenRelationListener listener : this.chosenRelationListeners) {
            listener.chosenRelationChanged(oldRel, this.chosenRelation);
        }
    }

    public Relation get() {
        return this.chosenRelation;
    }

    public void clear() {
        this.set(null);
    }

    public boolean isMultipolygon() {
        if (this.chosenRelation == null) {
            return false;
        }
        String type = this.chosenRelation.get("type");
        if (type == null) {
            return false;
        }
        for (String t : MULTIPOLYGON_TYPES) {
            if (!t.equals(type)) continue;
            return true;
        }
        return false;
    }

    public int getSegmentsCount() {
        return 0;
    }

    public int getCirclesCount() {
        return 0;
    }

    protected void analyse() {
    }

    public void addChosenRelationListener(ChosenRelationListener listener) {
        this.chosenRelationListeners.add(listener);
    }

    public void removeChosenRelationListener(ChosenRelationListener listener) {
        this.chosenRelationListeners.remove(listener);
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
        this.clear();
        if (newLayer != null && oldLayer == null) {
            Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        } else if (oldLayer != null) {
            Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        if (this.chosenRelation == null) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        Composite oldComposite = g.getComposite();
        g.setColor(Color.yellow);
        g.setStroke(new BasicStroke(9.0f, 1, 1));
        g.setComposite(AlphaComposite.getInstance(3, 0.3f));
        for (OsmPrimitive element : this.chosenRelation.getMemberPrimitives()) {
            if (element.getType() == OsmPrimitiveType.NODE) {
                Node node = (Node)element;
                Point center = mv.getPoint(node);
                g.drawOval(center.x - 4, center.y - 4, 9, 9);
                continue;
            }
            if (element.getType() == OsmPrimitiveType.WAY) {
                Way way = (Way)element;
                if (way.getNodesCount() < 2) continue;
                GeneralPath b = new GeneralPath();
                Point p = mv.getPoint(way.getNode(0));
                b.moveTo(p.x, p.y);
                for (int i = 1; i < way.getNodesCount(); ++i) {
                    p = mv.getPoint(way.getNode(i));
                    b.lineTo(p.x, p.y);
                }
                g.draw(b);
                continue;
            }
            if (element.getType() != OsmPrimitiveType.RELATION) continue;
        }
        g.setStroke(oldStroke);
        g.setComposite(oldComposite);
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
        if (this.chosenRelation != null && event.getRelation().equals((Object)this.chosenRelation)) {
            this.fireRelationChanged(this.chosenRelation);
        }
    }

    public void tagsChanged(TagsChangedEvent event) {
        if (this.chosenRelation != null && event.getPrimitive().equals((Object)this.chosenRelation)) {
            this.fireRelationChanged(this.chosenRelation);
        }
    }

    public void dataChanged(DataChangedEvent event) {
        if (this.chosenRelation != null) {
            this.fireRelationChanged(this.chosenRelation);
        }
    }

    public void primtivesRemoved(PrimitivesRemovedEvent event) {
        if (this.chosenRelation != null && event.getPrimitives().contains(this.chosenRelation)) {
            this.clear();
        }
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
        if (this.chosenRelation != null) {
            this.fireRelationChanged(this.chosenRelation);
        }
    }

    public void primtivesAdded(PrimitivesAddedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }
}

