/*
 * Decompiled with CFR 0.152.
 */
package relcontext.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.MultipolygonCreate;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class SortAndFixAction
extends AbstractAction
implements ChosenRelationListener {
    private ChosenRelation rel;

    public SortAndFixAction(ChosenRelation rel) {
        this.putValue("SmallIcon", ImageProvider.get((String)"data", (String)"warning"));
        this.putValue("ShortDescription", I18n.tr((String)"Fix roles of the chosen relation members"));
        this.rel = rel;
        rel.addChosenRelationListener(this);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.rel.get() == null) {
            return;
        }
        Relation r = this.rel.get();
        boolean fixed = false;
        Relation rr = this.fixMultipolygonRoles(r);
        if (rr != null) {
            r = rr;
            fixed = true;
        }
        if ((rr = this.fixBoundaryRoles(r)) != null) {
            r = rr;
            fixed = true;
        }
        if (fixed) {
            Main.main.undoRedo.add((Command)new ChangeCommand((OsmPrimitive)this.rel.get(), (OsmPrimitive)r));
        }
    }

    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setEnabled(newRelation != null && !this.isIncomplete(newRelation) && (this.areMultipolygonTagsEmpty() || this.areBoundaryTagsNotRight()));
    }

    protected boolean isIncomplete(Relation r) {
        if (r == null || r.isIncomplete() || r.isDeleted()) {
            return true;
        }
        for (RelationMember m : r.getMembers()) {
            if (!m.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    private boolean areMultipolygonTagsEmpty() {
        Relation r;
        Relation relation = r = this.rel == null ? null : this.rel.get();
        if (r == null || r.getMembersCount() == 0 || !this.rel.isMultipolygon()) {
            return false;
        }
        for (RelationMember m : r.getMembers()) {
            if (!m.getType().equals((Object)OsmPrimitiveType.WAY) || m.getRole() != null && (m.getRole().equals("outer") || m.getRole().equals("inner"))) continue;
            return true;
        }
        return false;
    }

    private boolean areBoundaryTagsNotRight() {
        Relation r;
        Relation relation = r = this.rel == null ? null : this.rel.get();
        if (r == null || r.getMembersCount() == 0 || !r.hasKey("type") || !r.get("type").equals("boundary")) {
            return false;
        }
        for (RelationMember m : r.getMembers()) {
            if (m.getType().equals((Object)OsmPrimitiveType.RELATION) && (m.getRole() == null || !m.getRole().equals("subarea"))) {
                return true;
            }
            if (!m.getType().equals((Object)OsmPrimitiveType.NODE) || m.getRole() != null && (m.getRole().equals("label") || m.getRole().equals("admin_centre"))) continue;
            return true;
        }
        return false;
    }

    private Relation fixMultipolygonRoles(Relation source) {
        ArrayList<Way> ways = new ArrayList<Way>();
        for (OsmPrimitive p : source.getMemberPrimitives()) {
            if (!(p instanceof Way)) continue;
            ways.add((Way)p);
        }
        MultipolygonCreate mpc = new MultipolygonCreate();
        String error = mpc.makeFromWays(ways);
        if (error != null) {
            return null;
        }
        Relation r = new Relation(source);
        boolean fixed = false;
        HashSet<Way> outerWays = new HashSet<Way>();
        for (MultipolygonCreate.JoinedPolygon poly : mpc.outerWays) {
            for (Way w : poly.ways) {
                outerWays.add(w);
            }
        }
        HashSet<Way> innerWays = new HashSet<Way>();
        for (MultipolygonCreate.JoinedPolygon poly : mpc.innerWays) {
            for (Way w : poly.ways) {
                innerWays.add(w);
            }
        }
        for (int i = 0; i < r.getMembersCount(); ++i) {
            RelationMember m = r.getMember(i);
            if (!m.isWay()) continue;
            String role = null;
            if (outerWays.contains((Way)m.getMember())) {
                role = "outer";
            } else if (innerWays.contains((Way)m.getMember())) {
                role = "inner";
            }
            if (role == null || role.equals(m.getRole())) continue;
            r.setMember(i, new RelationMember(role, m.getMember()));
            fixed = true;
        }
        return fixed ? r : null;
    }

    private Relation fixBoundaryRoles(Relation source) {
        Relation r = new Relation(source);
        boolean fixed = false;
        for (int i = 0; i < r.getMembersCount(); ++i) {
            Node n;
            RelationMember m = r.getMember(i);
            String role = null;
            if (m.isRelation()) {
                role = "subarea";
            } else if (m.isNode() && !(n = (Node)m.getMember()).isIncomplete()) {
                role = n.hasKey("place") ? "admin_centre" : "label";
            }
            if (role == null || role.equals(m.getRole())) continue;
            r.setMember(i, new RelationMember(role, m.getMember()));
            fixed = true;
        }
        return fixed ? r : null;
    }
}

