/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.osb.gui.OsbDialog;
import org.openstreetmap.josm.plugins.osb.gui.action.ActionQueue;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbActionObserver;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsbAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private List<OsbActionObserver> observers = new ArrayList<OsbActionObserver>();
    protected final OsbDialog dialog;
    protected boolean cancelled = false;
    protected final ActionQueue actionQueue;

    public OsbAction(String name, OsbDialog osbDialog) {
        super(name);
        this.dialog = osbDialog;
        this.actionQueue = osbDialog.getActionQueue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cancelled = false;
        try {
            this.doActionPerformed(e);
            if (!this.cancelled) {
                if (!Main.pref.getBoolean("osb.api.offline")) {
                    this.execute();
                    for (OsbActionObserver obs : this.observers) {
                        obs.actionPerformed(this);
                    }
                } else {
                    OsbAction action = this.clone();
                    this.actionQueue.offer(action);
                }
            }
        }
        catch (Exception e1) {
            System.err.println("Couldn't execute action " + this.getClass().getSimpleName());
            e1.printStackTrace();
        }
    }

    protected abstract void doActionPerformed(ActionEvent var1) throws Exception;

    public void addActionObserver(OsbActionObserver obs) {
        this.observers.add(obs);
    }

    public void removeActionObserver(OsbActionObserver obs) {
        this.observers.remove(obs);
    }

    protected String addMesgInfo(String msg) {
        String nickname = Main.pref.get("osb.nickname");
        if (nickname == null || nickname.length() == 0) {
            nickname = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Please enter a user name"));
            if (nickname == null) {
                nickname = "NoName";
            } else {
                Main.pref.put("osb.nickname", nickname);
            }
        }
        String info = nickname;
        if (Main.pref.getBoolean("osb.include_date")) {
            String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.ENGLISH).format(new Date());
            info = info.concat(", ").concat(date);
        }
        return msg.concat(" [").concat(info).concat("]");
    }

    public List<OsbActionObserver> getActionObservers() {
        return this.observers;
    }

    public abstract void execute() throws Exception;

    @Override
    public abstract OsbAction clone();
}

