/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.service.value;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

public class Type
implements Serializable {
    private static final long serialVersionUID = 4022464908172242274L;
    private String key;
    private String value;
    private static HashMap<String, Type> table = null;
    public static final Type WRONG_TURN = new Type("wrong_turn", "Wrong turn");
    public static final Type BAD_ROUTING = new Type("bad_routing", "Bad routing");
    public static final Type ONEWAY_ROAD = new Type("oneway_road", "Oneway road");
    public static final Type BLOCKED_STREET = new Type("blocked_street", "Blocked streeet");
    public static final Type MISSING_STREET = new Type("missing_street", "Missing street");
    public static final Type WRONG_ROUNDABOUT = new Type("wrong_roundabout", "Wrong roundabout");
    public static final Type MISSING_SPEEDLIMIT = new Type("missing_speedlimit", "Missing speedlimit");
    public static final Type OTHER = new Type("other", "Other");

    public Type() {
    }

    public Type(String key, String value) {
        this.key = key;
        this.value = value;
        if (table == null) {
            table = new HashMap();
        }
        table.put(key, this);
    }

    public static Type getType(String value) throws IllegalStateException {
        Type type = table.get(value);
        if (type == null) {
            type = OTHER;
        }
        return type;
    }

    public static Type getTypeFromValue(String value) {
        Type type = null;
        for (Type obj : table.values()) {
            if (!obj.getValue().equals(value)) continue;
            type = obj;
            break;
        }
        return type;
    }

    public static Type[] getTypes() {
        Collection<Type> collection = table.values();
        return collection.toArray(new Type[0]);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

