/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import org.openstreetmap.josm.plugins.mapdust.gui.component.model.ActionListModel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.model.BugsListModel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.model.TypesListModel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.renderer.ActionListCellRenderer;
import org.openstreetmap.josm.plugins.mapdust.gui.component.renderer.BugListCellRenderer;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustAction;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtil {
    public static JLabel createJLabel(String text, Font font, Rectangle bounds) {
        JLabel jLabel = new JLabel();
        if (bounds != null) {
            jLabel.setBounds(bounds);
        }
        jLabel.setText(text);
        jLabel.setFont(font);
        return jLabel;
    }

    public static JLabel createJLabel(String text, String iconName, Rectangle bounds) {
        JLabel jLabel = new JLabel(text, ImageProvider.get((String)iconName), 2);
        jLabel.setBounds(bounds);
        jLabel.setFont(new Font("Times New Roman", 1, 12));
        return jLabel;
    }

    public static JButton createJButton(String text, Rectangle bounds, Action action) {
        JButton jButton = null;
        jButton = action != null ? new JButton(action) : new JButton();
        jButton.setFont(new Font("Times New Roman", 1, 14));
        jButton.setText(text);
        jButton.setBounds(bounds);
        return jButton;
    }

    public static JToggleButton createJButton(String text, String toolTipText, String iconName, AbstractAction action) {
        JToggleButton jButton = new JToggleButton(I18n.tr((String)text));
        if (action != null) {
            jButton.setAction(action);
        }
        if (toolTipText != null) {
            jButton.setToolTipText(I18n.tr((String)toolTipText));
        }
        if (iconName != null) {
            jButton.setIcon(ImageProvider.get((String)iconName));
        } else {
            jButton.setText(I18n.tr((String)text));
            jButton.setFont(new Font("Times New Roman", 1, 14));
        }
        return jButton;
    }

    public static JTextField createJTextField(Rectangle bounds) {
        JTextField txtField = new JTextField();
        txtField.setFont(new Font("Times New Roman", 0, 12));
        txtField.setBounds(bounds);
        return txtField;
    }

    public static JScrollPane createJScrollPane(Component component, Rectangle bounds, Color backgroundColor, boolean noBorder, boolean visible) {
        JScrollPane pane = new JScrollPane();
        if (bounds != null) {
            pane.setBounds(bounds);
        }
        pane.setBackground(backgroundColor);
        pane.setViewportView(component);
        if (noBorder) {
            pane.setBorder(null);
        }
        if (!visible) {
            pane.setVisible(false);
        }
        return pane;
    }

    public static JScrollPane createJScrollPane(JList list) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(list);
        jScrollPane.setAutoscrolls(true);
        return jScrollPane;
    }

    public static JList createJList(List<MapdustAction> list) {
        JList<Object> jList = new JList<Object>(new ActionListModel(list));
        jList.setBorder(new LineBorder(Color.black, 1, false));
        jList.setSelectionMode(0);
        jList.setCellRenderer(new ActionListCellRenderer());
        jList.setAutoscrolls(true);
        return jList;
    }

    public static JList createJList(List<MapdustBug> bugsList, JPopupMenu menu) {
        JList<Object> jList = new JList<Object>(new BugsListModel(bugsList));
        jList.setBorder(new LineBorder(Color.black, 1, false));
        jList.setSelectionMode(0);
        jList.setCellRenderer(new BugListCellRenderer());
        jList.setAutoscrolls(true);
        return jList;
    }

    public static JMenuItem createJMenuItem(Action action, String title, String iconPath) {
        JMenuItem menuItem = new JMenuItem(action);
        menuItem.setText(title);
        menuItem.setIcon(ImageProvider.get((String)iconPath));
        menuItem.setFont(new Font("Times New Roman", 1, 12));
        return menuItem;
    }

    public static JTextPane createJTextPane(String text, Color backgroundColor) {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setBorder(null);
        jTextPane.setEditable(false);
        jTextPane.setBackground(backgroundColor);
        jTextPane.setFont(new Font("Times New Roman", 0, 14));
        if (text != null) {
            jTextPane.setText(text);
        }
        jTextPane.setVerifyInputWhenFocusTarget(false);
        jTextPane.setAutoscrolls(false);
        return jTextPane;
    }

    public static JComboBox createJComboBox(Rectangle bounds, ListCellRenderer renderer, Color backgroundColor) {
        JComboBox jComboBox = new JComboBox(new TypesListModel());
        jComboBox.setSelectedIndex(0);
        jComboBox.setBackground(backgroundColor);
        jComboBox.setFont(new Font("Times New Roman", 1, 12));
        jComboBox.setDoubleBuffered(false);
        jComboBox.setBorder(null);
        jComboBox.setBounds(bounds);
        if (renderer != null) {
            jComboBox.setRenderer(renderer);
            jComboBox.setMaximumRowCount(7);
        }
        return jComboBox;
    }

    public static JCheckBox createJCheckBox(Rectangle bounds) {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setBounds(bounds);
        return jCheckBox;
    }
}

