/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.contourmerge;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.contourmerge.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaySlice {
    private Way w;
    private int start;
    private int end;
    private boolean inDirection = true;

    public WaySlice(Way w, int start, int end) throws IllegalArgumentException {
        Assert.checkArgNotNull(w, "w");
        Assert.checkArg(start >= 0 && start < w.getNodesCount(), "start out of range, got {0}", start);
        Assert.checkArg(end >= 0 && end < w.getNodesCount(), "end out of range, got {0}", start);
        Assert.checkArg(start < end, "expected start < end, got start={0}, end={1}", start, end);
        this.w = w;
        this.start = start;
        this.end = end;
    }

    public WaySlice(Way w, int start, int end, boolean inDirection) throws IllegalArgumentException {
        this(w, start, end);
        if (!inDirection) {
            Assert.checkArg(w.isClosed(), "inDirection=false only supported provided w is closed", new Object[0]);
        }
        if (w.isClosed() && start == 0 && end == w.getNodesCount() - 1) {
            Assert.checkArg(false, "for a closed way, start and end must not both refer to the shared 'join'-node", new Object[0]);
        }
        this.inDirection = inDirection;
    }

    public Way getWay() {
        return this.w;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isInDirection() {
        return this.inDirection;
    }

    public Node getStartNode() {
        return this.w.getNode(this.start);
    }

    public Node getEndNode() {
        return this.w.getNode(this.end);
    }

    public int getStartTearOffIdx() {
        if (!this.w.isClosed()) {
            return this.start > 0 ? this.start - 1 : -1;
        }
        if (this.isInDirection()) {
            int lower = this.start - 1;
            if (lower < 0) {
                lower = this.w.getNodesCount() - 2;
            }
            return lower == this.end ? -1 : lower;
        }
        int lower = this.end - 1;
        if (lower < 0) {
            lower = this.w.getNodesCount() - 2;
        }
        return lower == this.start ? -1 : lower;
    }

    public Node getStartTearOffNode() {
        int i = this.getStartTearOffIdx();
        return i == -1 ? null : this.w.getNode(i);
    }

    public int getEndTearOffIdx() {
        if (!this.w.isClosed()) {
            return this.end < this.w.getNodesCount() - 1 ? this.end + 1 : -1;
        }
        if (this.inDirection) {
            int upper = this.end + 1;
            if (upper >= this.w.getNodesCount() - 1) {
                upper = 0;
            }
            return upper == this.start ? -1 : upper;
        }
        int upper = this.start + 1;
        if (upper >= this.w.getNodesCount() - 1) {
            upper = 0;
        }
        return upper == this.end ? -1 : upper;
    }

    public Node getEndTearOffNode() {
        int i = this.getEndTearOffIdx();
        return i == -1 ? null : this.w.getNode(i);
    }

    public int getNumSegments() {
        if (this.inDirection) {
            return this.end - this.start;
        }
        return this.start + (this.w.getNodesCount() - 1 - this.end);
    }

    public WaySlice getOpositeSlice() {
        if (!this.w.isClosed()) {
            return null;
        }
        return new WaySlice(this.w, this.start, this.end, !this.inDirection);
    }

    public Way replaceNodes(List<Node> newNodes) {
        Way nw = new Way(this.w);
        if (newNodes == null || newNodes.isEmpty()) {
            return nw;
        }
        if (!this.w.isClosed()) {
            ArrayList<Node> oldNodes = new ArrayList<Node>(this.w.getNodes());
            for (int i = this.start; i <= this.end; ++i) {
                oldNodes.remove(this.start);
            }
            oldNodes.addAll(this.start, newNodes);
            nw.setNodes(oldNodes);
        } else {
            ArrayList<Node> oldNodes = new ArrayList<Node>(this.w.getNodes());
            if (this.inDirection) {
                if (this.start == 0) {
                    oldNodes.remove(oldNodes.size() - 1);
                }
                for (int i = this.start; i <= this.end; ++i) {
                    oldNodes.remove(this.start);
                }
                oldNodes.addAll(this.start, newNodes);
                if (this.start == 0) {
                    oldNodes.add(newNodes.get(0));
                }
                nw.setNodes(oldNodes);
            } else {
                int i;
                int upper = oldNodes.size() - 1;
                for (i = this.end; i <= upper; ++i) {
                    oldNodes.remove(this.end);
                }
                for (i = 0; i <= this.start; ++i) {
                    oldNodes.remove(0);
                }
                oldNodes.addAll(0, newNodes);
                oldNodes.add(newNodes.get(0));
                nw.setNodes(oldNodes);
            }
        }
        return nw;
    }

    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (!this.w.isClosed()) {
            nodes.addAll(this.w.getNodes().subList(this.start, this.end + 1));
        } else if (this.inDirection) {
            nodes.addAll(this.w.getNodes().subList(this.start, this.end + 1));
        } else {
            int i;
            for (i = this.end; i <= this.w.getNodesCount() - 2; ++i) {
                nodes.add(this.w.getNode(i));
            }
            for (i = 0; i <= this.start; ++i) {
                nodes.add(this.w.getNode(i));
            }
        }
        return nodes;
    }

    protected boolean hasSlings() {
        int i;
        HashSet<Node> nodeSet = new HashSet<Node>();
        if (this.w.isClosed()) {
            if (this.isInDirection()) {
                for (i = this.start; i <= this.end; ++i) {
                    nodeSet.add(this.w.getNode(i));
                }
            } else {
                for (i = this.start; i > 0; --i) {
                    nodeSet.add(this.w.getNode(i));
                }
                for (i = this.w.getNodesCount() - 1; i >= this.end; --i) {
                    nodeSet.add(this.w.getNode(i));
                }
            }
        } else {
            for (i = this.start; i <= this.end; ++i) {
                nodeSet.add(this.w.getNode(i));
            }
        }
        HashSet<Node> seen = new HashSet<Node>();
        for (int i2 = 0; i2 < (this.w.isClosed() ? this.w.getNodesCount() - 1 : this.w.getNodesCount()); ++i2) {
            Node n = this.w.getNode(i2);
            if (seen.contains(n)) {
                return true;
            }
            if (!nodeSet.contains(n)) continue;
            seen.add(n);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<way-slice ").append("way=").append(this.w.getPrimitiveId()).append(", start=").append(this.start).append(", end=").append(this.end).append(", isInDirection=").append(this.isInDirection()).append(">");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + (this.inDirection ? 1231 : 1237);
        result = 31 * result + this.start;
        result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WaySlice other = (WaySlice)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.inDirection != other.inDirection) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return !(this.w == null ? other.w != null : !this.w.equals((Object)other.w));
    }
}

