/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.contourmerge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.plugins.contourmerge.ContourMergeModel;
import org.openstreetmap.josm.plugins.contourmerge.ContourMergePlugin;
import org.openstreetmap.josm.plugins.contourmerge.WaySlice;
import org.openstreetmap.josm.plugins.contourmerge.util.Assert;

public class ContourMergeView
implements MapViewPaintable {
    private static ContourMergeView instance;

    public static ContourMergeView getInstance() {
        return instance == null ? (instance = new ContourMergeView()) : instance;
    }

    public void wireToJOSM() {
        if (Main.map == null) {
            return;
        }
        if (Main.map.mapView == null) {
            return;
        }
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
    }

    public void unwireFromJOSM() {
        if (Main.map == null) {
            return;
        }
        if (Main.map.mapView == null) {
            return;
        }
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
    }

    protected void decorateFeedbackNode(Graphics2D g, MapView mv, Bounds bbox) {
        Node n = ContourMergePlugin.getModelManager().getActiveModel().getFeedbackNode();
        if (n == null) {
            return;
        }
    }

    protected void decorateSelectedNode(Graphics2D g, MapView mv, Bounds bbox, Node node) {
        if (!bbox.contains(node.getCoor())) {
            return;
        }
        Point p = mv.getPoint(node.getCoor());
        g.translate(p.x, p.y);
        g.setColor(Color.ORANGE);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.drawLine(-5, 5, 5, -5);
        g.drawLine(-5, -5, 5, 5);
        g.setColor(Color.ORANGE.brighter());
        g.setStroke(new BasicStroke(1.0f, 1, 1));
        g.drawLine(-5, 5, 5, -5);
        g.drawLine(-5, -5, 5, 5);
        g.translate(-p.x, -p.y);
    }

    protected void decorateSelectedNodes(Graphics2D g, MapView mv, Bounds bbox) {
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model == null) {
            return;
        }
        for (Node n : model.getSelectedNodes()) {
            this.decorateSelectedNode(g, mv, bbox, n);
        }
    }

    protected void highlightWaySlice(Graphics2D g, MapView mv, Bounds bbox, WaySlice slice) {
        Path2D polyline = ContourMergeView.project(mv, slice);
        g.setColor(Color.RED);
        g.setStroke(new BasicStroke(2.0f, 0, 1));
        g.draw(polyline);
    }

    public static Path2D project(MapView mv, WaySlice ws) throws IllegalArgumentException {
        Assert.checkArgNotNull(mv, "mv");
        Assert.checkArgNotNull(ws, "ws");
        Path2D.Float polyline = new Path2D.Float();
        if (ws.isInDirection()) {
            for (int i = ws.getStart(); i <= ws.getEnd(); ++i) {
                Point p = mv.getPoint(ws.getWay().getNode(i).getCoor());
                if (i == ws.getStart()) {
                    polyline.moveTo(p.x, p.y);
                    continue;
                }
                polyline.lineTo(p.x, p.y);
            }
        } else {
            Point p;
            int i;
            for (i = ws.getStart(); i >= 0; --i) {
                p = mv.getPoint(ws.getWay().getNode(i).getCoor());
                if (i == ws.getStart()) {
                    polyline.moveTo(p.x, p.y);
                    continue;
                }
                polyline.lineTo(p.x, p.y);
            }
            for (i = ws.getWay().getNodesCount() - 2; i >= ws.getEnd(); --i) {
                p = mv.getPoint(ws.getWay().getNode(i).getCoor());
                if (i == ws.getStart()) {
                    polyline.moveTo(p.x, p.y);
                    continue;
                }
                polyline.lineTo(p.x, p.y);
            }
        }
        return polyline;
    }

    public Path2D project(MapView mv, WaySlice ws, Point displacement) throws IllegalArgumentException {
        Assert.checkArgNotNull(mv, "mv");
        if (displacement == null) {
            displacement = new Point(0, 0);
        }
        Path2D polyline = ContourMergeView.project(mv, ws);
        AffineTransform at = new AffineTransform();
        at.setToTranslation(displacement.x, displacement.y);
        polyline = new Path2D.Float(polyline, at);
        return polyline;
    }

    protected void paintHelperLinesFromDragSourceToDraggedWaySlice(Graphics2D g, MapView mv) {
        Point p2;
        Point p1;
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model == null) {
            return;
        }
        if (!model.isDragging()) {
            return;
        }
        WaySlice dragSource = model.getDragSource();
        Node lowerTearOffNode = dragSource.getStartTearOffNode();
        Node upperTearOffNode = dragSource.getEndTearOffNode();
        Point offset = model.getDragOffset();
        float[] dashPattern = new float[]{2.0f, 3.0f, 2.0f, 3.0f};
        g.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, dashPattern, 0.0f));
        boolean crossing = this.helperLinesAreCrossing(mv, dragSource, offset);
        if (lowerTearOffNode != null) {
            p1 = mv.getPoint(!crossing ? dragSource.getStartNode() : dragSource.getEndNode());
            p1 = new Point(p1.x + offset.x, p1.y + offset.y);
            p2 = mv.getPoint(lowerTearOffNode);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
        if (upperTearOffNode != null) {
            p1 = mv.getPoint(!crossing ? dragSource.getEndNode() : dragSource.getStartNode());
            p1 = new Point(p1.x + offset.x, p1.y + offset.y);
            p2 = mv.getPoint(upperTearOffNode);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
    }

    protected boolean helperLinesAreCrossing(MapView mv, WaySlice dragSource, WaySlice dropTarget) {
        Node s2;
        Node s1 = dragSource.getStartTearOffNode();
        if (s1 == null) {
            s1 = dragSource.getStartNode();
        }
        if ((s2 = dragSource.getEndTearOffNode()) == null) {
            s2 = dragSource.getEndNode();
        }
        Point sp1 = mv.getPoint(s1);
        Point sp2 = mv.getPoint(s2);
        Point tp1 = mv.getPoint(dropTarget.getStartNode());
        Point tp2 = mv.getPoint(dropTarget.getEndNode());
        return this.helperLinesAreCrossing(sp1, sp2, tp1, tp2);
    }

    protected boolean helperLinesAreCrossing(Point s1, Point s2, Point t1, Point t2) {
        Line2D.Float l1 = new Line2D.Float(s1.x, s1.y, t1.x, t1.y);
        Line2D.Float l2 = new Line2D.Float(s2.x, s2.y, t2.x, t2.y);
        return l1.intersectsLine(l2);
    }

    protected boolean helperLinesAreCrossing(MapView mv, WaySlice dragSource, Point dragOffset) {
        Node s2;
        Node s1 = dragSource.getStartTearOffNode();
        if (s1 == null) {
            s1 = dragSource.getStartNode();
        }
        if ((s2 = dragSource.getEndTearOffNode()) == null) {
            s2 = dragSource.getEndNode();
        }
        Point sp1 = mv.getPoint(s1);
        Point sp2 = mv.getPoint(s2);
        Point tp1 = mv.getPoint(dragSource.getStartNode());
        tp1 = new Point(tp1.x + dragOffset.x, tp1.y + dragOffset.y);
        Point tp2 = mv.getPoint(dragSource.getEndNode());
        tp2 = new Point(tp2.x + dragOffset.x, tp2.y + dragOffset.y);
        return this.helperLinesAreCrossing(sp1, sp2, tp1, tp2);
    }

    protected void paintHelperLinesFromDragSourceToDropTarget(Graphics2D g, MapView mv) {
        Point p2;
        Point p1;
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model == null) {
            return;
        }
        if (!model.isDragging()) {
            return;
        }
        WaySlice dragSource = model.getDragSource();
        WaySlice dropTarget = model.getDropTarget();
        Node lowerTearOffNode = dragSource.getStartTearOffNode();
        Node upperTearOffNode = dragSource.getEndTearOffNode();
        float[] dashPattern = new float[]{2.0f, 3.0f, 2.0f, 3.0f};
        g.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, dashPattern, 0.0f));
        boolean crossing = this.helperLinesAreCrossing(mv, dragSource, dropTarget);
        if (lowerTearOffNode != null) {
            p1 = mv.getPoint(lowerTearOffNode);
            p2 = mv.getPoint(!crossing ? dropTarget.getStartNode() : dropTarget.getEndNode());
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
        if (upperTearOffNode != null) {
            p1 = mv.getPoint(upperTearOffNode);
            p2 = mv.getPoint(!crossing ? dropTarget.getEndNode() : dropTarget.getStartNode());
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
    }

    protected void paintDraggedWaySlice(Graphics2D g, MapView mv, Bounds bbox) {
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model == null) {
            return;
        }
        if (!model.isDragging()) {
            return;
        }
        WaySlice dragSource = model.getDragSource();
        WaySlice dropTarget = model.getDropTarget();
        if (dragSource == null) {
            return;
        }
        if (dropTarget == null) {
            Path2D polyline = this.project(mv, dragSource, model.getDragOffset());
            g.setColor(Color.RED);
            float[] dashPattern = new float[]{10.0f, 5.0f, 10.0f, 5.0f};
            g.setStroke(new BasicStroke(2.0f, 0, 1, 1.0f, dashPattern, 0.0f));
            g.draw(polyline);
            this.paintHelperLinesFromDragSourceToDraggedWaySlice(g, mv);
        } else {
            this.paintHelperLinesFromDragSourceToDropTarget(g, mv);
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        WaySlice dropTargetSlice;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!ContourMergePlugin.isEnabled()) {
            return;
        }
        ContourMergeModel model = ContourMergePlugin.getModelManager().getActiveModel();
        if (model == null) {
            return;
        }
        if (!model.getLayer().isVisible()) {
            return;
        }
        this.decorateSelectedNodes(g, mv, bbox);
        this.decorateFeedbackNode(g, mv, bbox);
        WaySlice dragSourceSlice = model.getDragSource();
        if (dragSourceSlice != null) {
            this.highlightWaySlice(g, mv, bbox, dragSourceSlice);
        }
        if ((dropTargetSlice = model.getDropTarget()) != null) {
            this.highlightWaySlice(g, mv, bbox, dropTargetSlice);
        }
        if (model.isDragging()) {
            this.paintDraggedWaySlice(g, mv, bbox);
        }
    }
}

