/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.contourmerge;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.contourmerge.ContourMergeModel;
import org.openstreetmap.josm.plugins.contourmerge.util.Assert;

public class ContourMergeModelManager
implements MapView.LayerChangeListener {
    private static ContourMergeModelManager instance;
    private final Map<OsmDataLayer, ContourMergeModel> models = new HashMap<OsmDataLayer, ContourMergeModel>();

    public static ContourMergeModelManager getInstance() {
        if (instance == null) {
            instance = new ContourMergeModelManager();
        }
        return instance;
    }

    public void wireToJOSM() {
        this.models.clear();
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public void unwireFromJOSM() {
        this.models.clear();
        MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
    }

    public ContourMergeModel getModel(OsmDataLayer layer) throws IllegalArgumentException {
        Assert.checkArgNotNull(layer, "layer");
        return this.models.get(layer);
    }

    public ContourMergeModel getActiveModel() {
        if (Main.map == null) {
            return null;
        }
        if (Main.map.mapView == null) {
            return null;
        }
        OsmDataLayer layer = Main.map.mapView.getEditLayer();
        if (layer == null) {
            return null;
        }
        return this.getModel(layer);
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (!(newLayer instanceof OsmDataLayer)) {
            return;
        }
        OsmDataLayer dl = (OsmDataLayer)newLayer;
        ContourMergeModel model = new ContourMergeModel(dl);
        dl.data.addDataSetListener((DataSetListener)model);
        this.models.put((OsmDataLayer)newLayer, model);
    }

    public void layerRemoved(Layer oldLayer) {
        if (!(oldLayer instanceof OsmDataLayer)) {
            return;
        }
        OsmDataLayer dl = (OsmDataLayer)oldLayer;
        ContourMergeModel model = this.models.get(dl);
        dl.data.removeDataSetListener((DataSetListener)model);
        this.models.remove(dl);
    }
}

