/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.model.Constants;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Turn {
    private final Relation relation;
    private final Lane from;
    private final Junction via;
    private final Road.End to;
    private final Way fromWay;
    private final Way toWay;

    public static Set<Turn> load(Junction junction) {
        HashSet<Turn> result = new HashSet<Turn>();
        for (OsmPrimitive p : junction.getNode().getReferrers()) {
            Relation r;
            if (p.getType() != OsmPrimitiveType.RELATION || !(r = (Relation)p).get("type").equals("turnlanes:turns")) continue;
            result.addAll(Turn.load(junction, r));
        }
        return result;
    }

    private static Set<Turn> load(Junction junction, Relation turns) {
        if (!"turnlanes:turns".equals(turns.get("type"))) {
            throw new IllegalArgumentException("Relation must be a of type \"turnlanes:turns\".");
        }
        Way fromWay = null;
        Way toWay = null;
        Node via = null;
        List<Integer> lanes = Turn.split(turns.get("lanes"));
        List<Integer> extraLanes = Turn.split(turns.get("lanes:extra"));
        for (RelationMember m : turns.getMembers()) {
            String r = m.getRole();
            if ("via".equals(r)) {
                if (via != null) {
                    throw new IllegalArgumentException("More than one \"via\" members.");
                }
                via = m.getNode();
                continue;
            }
            if ("from".equals(r)) {
                if (fromWay != null) {
                    throw new IllegalArgumentException("More than one \"from\" members.");
                }
                fromWay = m.getWay();
                continue;
            }
            if (!"to".equals(r)) continue;
            if (toWay != null) {
                throw new IllegalArgumentException("More than one \"to\" members.");
            }
            toWay = m.getWay();
        }
        if (!via.equals((Object)junction.getNode())) {
            throw new IllegalArgumentException("Turn is for a different junction.");
        }
        Road.End to = junction.getRoadEnd(toWay);
        HashSet<Turn> result = new HashSet<Turn>();
        for (Road r : junction.getRoads()) {
            boolean reverse;
            if (r.getRoute().getFirstSegment().getWay().equals((Object)fromWay) && r.getRoute().getFirstSegment().getStart().equals((Object)via)) {
                reverse = true;
            } else {
                if (!r.getRoute().getLastSegment().getWay().equals((Object)fromWay) || !r.getRoute().getLastSegment().getEnd().equals((Object)via)) continue;
                reverse = false;
            }
            for (int l : lanes) {
                result.add(new Turn(turns, r.getLane(reverse, l), junction, to, fromWay, toWay));
            }
            for (int l : extraLanes) {
                result.add(new Turn(turns, r.getExtraLane(reverse, l), junction, to, fromWay, toWay));
            }
        }
        return result;
    }

    static List<Integer> split(String lanes) {
        if (lanes == null) {
            return new ArrayList<Integer>(1);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String lane : Constants.SPLIT_PATTERN.split(lanes)) {
            result.add(Integer.parseInt(lane));
        }
        return result;
    }

    static String join(List<Integer> list) {
        if (list.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder(list.size() * (2 + ";".length()));
        for (int e : list) {
            builder.append(e).append(";");
        }
        builder.setLength(builder.length() - ";".length());
        return builder.toString();
    }

    public Turn(Relation relation, Lane from, Junction via, Road.End to, Way fromWay, Way toWay) {
        this.relation = relation;
        this.from = from;
        this.via = via;
        this.to = to;
        this.fromWay = fromWay;
        this.toWay = toWay;
    }

    public Lane getFrom() {
        return this.from;
    }

    public Junction getVia() {
        return this.via;
    }

    public Road.End getTo() {
        return this.to;
    }

    Relation getRelation() {
        return this.relation;
    }

    Way getFromWay() {
        return this.fromWay;
    }

    Way getToWay() {
        return this.toWay;
    }

    void remove() {
        List<Integer> lanes = Turn.split(this.relation.get("lanes"));
        List<Integer> extraLanes = Turn.split(this.relation.get("lanes:extra"));
        if (lanes.size() + extraLanes.size() == 1 && this.from.isExtra() ^ !lanes.isEmpty()) {
            this.relation.getDataSet().removePrimitive(this.relation.getPrimitiveId());
        } else if (this.from.isExtra()) {
            extraLanes.remove((Object)this.from.getIndex());
        } else {
            lanes.remove((Object)this.from.getIndex());
        }
        this.relation.put("lanes", Turn.join(lanes));
        this.relation.put("lanes:extra", Turn.join(extraLanes));
    }
}

