/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route {
    private final List<Segment> segments;

    public static Route load(Relation r) {
        Node end = Utils.getMemberNode(r, "end");
        List<Way> ws = Utils.getMemberWays(r, "ways");
        return Route.create(ws, end);
    }

    public static Route load(Relation left, Relation right, Way w) {
        List<Segment> rightSegments;
        left = left == null ? right : left;
        Relation relation = right = right == null ? left : right;
        if (left == null) {
            throw new IllegalArgumentException("At least one relation must not be null.");
        }
        Route leftRoute = Route.load(left);
        Route rightRoute = Route.load(right);
        int iLeft = 0;
        while (!w.equals((Object)leftRoute.getSegments().get(iLeft++).getWay())) {
        }
        int iRight = 0;
        while (!w.equals((Object)rightRoute.getSegments().get(iRight++).getWay())) {
        }
        int min = Math.min(iLeft, iRight);
        List<Segment> leftSegments = leftRoute.getSegments().subList(iLeft - min, iLeft);
        if (!((Object)leftSegments).equals(rightSegments = rightRoute.getSegments().subList(iRight - min, iRight))) {
            throw new IllegalArgumentException("Routes are split across different ways.");
        }
        return new Route(iLeft == min ? rightSegments : leftSegments);
    }

    public static Route create(List<Way> ws, Node end) {
        ArrayList<Segment> segments = new ArrayList<Segment>(ws.size());
        for (Way w : ws) {
            if (!w.isFirstLastNode(end)) {
                throw new IllegalArgumentException("Ways must be ordered.");
            }
            Node start = Utils.getOppositeEnd(w, end);
            segments.add(0, new Segment(start, w, end));
            end = start;
        }
        return new Route(segments);
    }

    private Route(List<Segment> segments) {
        this.segments = Collections.unmodifiableList(new ArrayList<Segment>(segments));
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public List<Node> getNodes() {
        ArrayList<Node> ns = new ArrayList<Node>();
        ns.add(this.segments.get(0).getStart());
        for (Segment s : this.segments) {
            ns.addAll(s.getNodes().subList(1, s.getNodes().size()));
        }
        return Collections.unmodifiableList(ns);
    }

    public double getLengthFrom(Way w) {
        double length = Double.NEGATIVE_INFINITY;
        for (Segment s : this.getSegments()) {
            length += s.getLength();
            if (!w.equals((Object)s.getWay())) continue;
            length = 0.0;
        }
        if (length < 0.0) {
            throw new IllegalArgumentException("Way must be part of the route.");
        }
        return length;
    }

    public double getLength() {
        double length = 0.0;
        for (Segment s : this.getSegments()) {
            length += s.getLength();
        }
        return length;
    }

    public Segment getFirstSegment() {
        return this.getSegments().get(0);
    }

    public Segment getLastSegment() {
        return this.getSegments().get(this.getSegments().size() - 1);
    }

    public Route subRoute(int fromIndex, int toIndex) {
        return new Route(this.segments.subList(fromIndex, toIndex));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Segment {
        private final Node start;
        private final Way way;
        private final Node end;
        private final List<Node> nodes;

        Segment(Node start, Way way, Node end) {
            this.start = start;
            this.way = way;
            this.end = end;
            List ns = way.getNodes();
            if (way.lastNode().equals((Object)start)) {
                Collections.reverse(ns);
            }
            this.nodes = Collections.unmodifiableList(ns);
        }

        public Node getStart() {
            return this.start;
        }

        public Way getWay() {
            return this.way;
        }

        public Node getEnd() {
            return this.end;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public double getLength() {
            double length = 0.0;
            Node last = this.nodes.get(0);
            for (Node n : this.nodes.subList(1, this.nodes.size())) {
                length += last.getCoor().greatCircleDistance(n.getCoor());
                last = n;
            }
            return length;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
            result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
            result = 31 * result + (this.way == null ? 0 : this.way.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Segment other = (Segment)obj;
            if (this.end == null ? other.end != null : !this.end.equals((Object)other.end)) {
                return false;
            }
            if (this.start == null ? other.start != null : !this.start.equals((Object)other.start)) {
                return false;
            }
            return !(this.way == null ? other.way != null : !this.way.equals((Object)other.way));
        }
    }
}

