/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.plugins.turnlanes.model.Route;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Road {
    private final ModelContainer container;
    private final Relation lengthsLeft;
    private final Relation lengthsRight;
    private final Route route;
    private final List<Lane> lanes;
    private final End fromEnd;
    private final End toEnd;

    public static List<Road> map(ModelContainer container, List<Way> ws, Junction j) {
        ArrayList<Road> result = new ArrayList<Road>();
        for (Way w : ws) {
            result.add(container.getRoad(w, j));
        }
        return result;
    }

    private static Pair<Relation, Relation> getLengthRelations(Way w, Node n) {
        ArrayList<Relation> left = new ArrayList<Relation>();
        ArrayList<Relation> right = new ArrayList<Relation>();
        for (OsmPrimitive p : w.getReferrers()) {
            Relation r;
            if (p.getType() != OsmPrimitiveType.RELATION || !"turnlanes:lengths".equals((r = (Relation)p).get("type")) || !Road.isRightDirection(r, w, n)) continue;
            if (r.get("lengths:left") != null) {
                left.add(r);
            }
            if (r.get("lengths:right") == null) continue;
            right.add(r);
        }
        if (left.size() > 1) {
            throw new IllegalArgumentException("Way is in " + left.size() + " lengths relations for given direction, both specifying left lane lengths.");
        }
        if (right.size() > 1) {
            throw new IllegalArgumentException("Way is in " + right.size() + " lengths relations for given direction, both specifying right lane lengths.");
        }
        return new Pair((Object)(left.isEmpty() ? null : (Relation)left.get(0)), right.isEmpty() ? null : (Relation)right.get(0));
    }

    private static boolean isRightDirection(Relation r, Way w, Node n) {
        for (Route.Segment s : Route.load(r).getSegments()) {
            if (!w.equals((Object)s.getWay())) continue;
            return n.equals((Object)s.getEnd());
        }
        return false;
    }

    Road(ModelContainer container, Way w, Junction j) {
        this.container = container;
        this.toEnd = new End(j);
        Node n = j.getNode();
        if (!w.isFirstLastNode(n)) {
            throw new IllegalArgumentException("Way must start or end in given node.");
        }
        Pair<Relation, Relation> lr = Road.getLengthRelations(w, n);
        this.lengthsLeft = (Relation)lr.a;
        this.lengthsRight = (Relation)lr.b;
        this.route = this.lengthsLeft == null && this.lengthsRight == null ? Route.create(Arrays.asList(w), n) : Route.load(this.lengthsLeft, this.lengthsRight, w);
        this.lanes = this.lengthsLeft == null && this.lengthsRight == null ? Lane.load(this) : Lane.load(this, this.lengthsLeft, this.lengthsRight, w);
        List<Node> nodes = this.route.getNodes();
        this.fromEnd = new End(container.getOrCreateJunction(nodes.get(0)));
        this.fromEnd.getJunction().addRoad(this);
        this.toEnd.getJunction().addRoad(this);
    }

    public End getFromEnd() {
        return this.fromEnd;
    }

    public End getToEnd() {
        return this.toEnd;
    }

    public Route getRoute() {
        return this.route;
    }

    public List<Lane> getLanes() {
        return this.lanes;
    }

    public double getLength() {
        return this.route.getLength();
    }

    void updateLengths() {
        String lengths;
        if (this.lengthsLeft != null) {
            lengths = "";
            for (int i = this.lanes.size() - 1; i >= 0; --i) {
                Lane l = this.lanes.get(i);
                if (l.getKind() != Lane.Kind.EXTRA_LEFT) continue;
                lengths = lengths + this.toLengthString(l.getTotalLength()) + ";";
            }
            this.lengthsLeft.put("lengths:left", lengths.substring(0, lengths.length() - ";".length()));
        }
        if (this.lengthsRight != null) {
            lengths = "";
            for (Lane l : this.lanes) {
                if (l.getKind() != Lane.Kind.EXTRA_RIGHT) continue;
                lengths = lengths + this.toLengthString(l.getTotalLength()) + ";";
            }
            this.lengthsRight.put("lengths:right", lengths.substring(0, lengths.length() - ";".length()));
        }
    }

    private String toLengthString(double length) {
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
        dfs.setDecimalSeparator('.');
        DecimalFormat nf = new DecimalFormat("0.0", dfs);
        nf.setRoundingMode(RoundingMode.HALF_UP);
        return nf.format(length);
    }

    public Lane getLane(boolean reverse, int index) {
        for (Lane l : this.lanes) {
            if (l.isExtra() || l.isReverse() != reverse || l.getIndex() != index) continue;
            return l;
        }
        throw new IllegalArgumentException("No such lane.");
    }

    public Lane getExtraLane(boolean reverse, int index) {
        for (Lane l : this.lanes) {
            if (!l.isExtra() || l.isReverse() != reverse || l.getIndex() != index) continue;
            return l;
        }
        throw new IllegalArgumentException("No such lane.");
    }

    public ModelContainer getContainer() {
        return this.container;
    }

    private void addLength(boolean left, double length) {
        Relation l = this.lengthsLeft;
        Relation r = this.lengthsRight;
        Node n = this.toEnd.getJunction().getNode();
        String lengthStr = this.toLengthString(length);
        Relation target = left ? (l == null ? (r == null || !Utils.getMemberNode(r, "end").equals((Object)n) ? this.createLengthsRelation() : r) : l) : (r == null ? (l == null || !Utils.getMemberNode(l, "end").equals((Object)n) ? this.createLengthsRelation() : l) : r);
        String key = left ? "lengths:left" : "lengths:right";
        String old = target.get(key);
        if (old == null) {
            target.put(key, lengthStr);
        } else {
            target.put(key, old + ";" + lengthStr);
        }
    }

    private Relation createLengthsRelation() {
        Node n = this.toEnd.getJunction().getNode();
        Relation r = new Relation();
        r.put("type", "turnlanes:lengths");
        r.addMember(new RelationMember("end", (OsmPrimitive)n));
        for (Route.Segment s : this.route.getSegments()) {
            r.addMember(1, new RelationMember("ways", (OsmPrimitive)s.getWay()));
        }
        n.getDataSet().addPrimitive((OsmPrimitive)r);
        return r;
    }

    public boolean isExtendable() {
        return this.lengthsLeft != null || this.lengthsRight != null;
    }

    public void extend(Way way) {
        if (this.lengthsLeft != null) {
            this.lengthsLeft.addMember(new RelationMember("ways", (OsmPrimitive)way));
        }
        if (this.lengthsRight != null) {
            this.lengthsRight.addMember(new RelationMember("ways", (OsmPrimitive)way));
        }
    }

    public class End {
        private final Junction junction;

        private End(Junction junction) {
            this.junction = junction;
        }

        public Road getRoad() {
            return Road.this;
        }

        public Junction getJunction() {
            return this.junction;
        }

        private boolean isFrom() {
            if (this == Road.this.fromEnd) {
                return true;
            }
            if (this == Road.this.toEnd) {
                return false;
            }
            throw new IllegalStateException();
        }

        public boolean isFromEnd() {
            return this.isFrom();
        }

        public boolean isToEnd() {
            return !this.isFrom();
        }

        public void addExtraLane(boolean left) {
            if (!this.isToEnd()) {
                throw new UnsupportedOperationException();
            }
            double length = Double.POSITIVE_INFINITY;
            for (Lane l : Road.this.getLanes()) {
                if (l.getKind() != (left ? Lane.Kind.EXTRA_LEFT : Lane.Kind.EXTRA_RIGHT)) continue;
                length = Math.min(length, l.getLength());
            }
            if (Double.isInfinite(length)) {
                length = Math.min(20.0, 3.0 * Road.this.getLength() / 4.0);
            }
            Road.this.addLength(left, length);
        }
    }
}

