/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Route;

public class ModelContainer {
    private final Map<Node, Junction> junctions = new HashMap<Node, Junction>();
    private final Map<Way, Road> roads = new HashMap<Way, Road>();
    private final Node primary;

    public static ModelContainer create(Node n) {
        ModelContainer container = new ModelContainer(n);
        container.getOrCreateJunction(n);
        return container;
    }

    private ModelContainer(Node primary) {
        this.primary = primary;
    }

    Junction getOrCreateJunction(Node n) {
        Junction existing = this.junctions.get(n);
        if (existing != null) {
            return existing;
        }
        return new Junction(this, n);
    }

    public Junction getJunction(Node n) {
        Junction j = this.junctions.get(n);
        if (j == null) {
            throw new IllegalArgumentException();
        }
        return j;
    }

    Road getRoad(Way w, Junction j) {
        Road existing = this.roads.get(w);
        if (existing != null && j.equals(existing.getToEnd().getJunction())) {
            return existing;
        }
        Road newRoad = new Road(this, w, j);
        for (Route.Segment s : newRoad.getRoute().getSegments()) {
            Road oldRoad = this.roads.put(s.getWay(), newRoad);
            if (oldRoad == null) continue;
            return this.mergeRoads(oldRoad, newRoad);
        }
        return newRoad;
    }

    private Road mergeRoads(Road a, Road b) {
        throw null;
    }

    void register(Junction j) {
        if (this.junctions.put(j.getNode(), j) != null) {
            throw new IllegalStateException();
        }
    }

    Junction getPrimary() {
        return this.junctions.get(this.primary);
    }
}

