/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.CollectionUtils;
import org.openstreetmap.josm.plugins.turnlanes.model.Constants;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Route;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lane {
    private final Road road;
    private final int index;
    private final Kind kind;
    private final boolean reverse;
    private final double extraLength;
    private double length = -1.0;

    public static List<Lane> load(Road road, Relation left, Relation right, Way w) {
        double extraLengthLeft = left == null ? 0.0 : Route.load(left).getLengthFrom(w);
        double extraLengthRight = right == null ? 0.0 : Route.load(right).getLengthFrom(w);
        List<Double> leftLengths = Lane.loadLengths(left, "lengths:left", extraLengthLeft);
        List<Double> rightLengths = Lane.loadLengths(right, "lengths:right", extraLengthRight);
        ArrayList<Lane> result = new ArrayList<Lane>(Lane.load(road));
        int mid = Lane.getReverseCount(result);
        result.addAll(mid, Lane.map(leftLengths, road, true, extraLengthLeft));
        result.addAll(Lane.map(rightLengths, road, false, extraLengthRight));
        return result;
    }

    private static List<Lane> map(List<Double> lengths, Road road, boolean left, double extraLength) {
        ArrayList<Lane> result = new ArrayList<Lane>(lengths.size());
        int index = left ? -lengths.size() : 1;
        for (Double l : left ? CollectionUtils.reverse(lengths) : lengths) {
            result.add(new Lane(road, index++, false, left, extraLength, l - extraLength));
        }
        return result;
    }

    private static int getReverseCount(List<Lane> ls) {
        int result = 0;
        for (Lane l : ls) {
            if (!l.isReverse()) continue;
            ++result;
        }
        return result;
    }

    static List<Double> loadLengths(Relation r, String key, double lengthBound) {
        ArrayList<Double> result = new ArrayList<Double>();
        if (r != null && r.get(key) != null) {
            for (String s : Constants.SPLIT_PATTERN.split(r.get(key))) {
                Double length = Double.parseDouble(s.trim());
                if (!(length > lengthBound)) continue;
                result.add(length);
            }
        }
        return result;
    }

    private static int getCount(Way w) {
        String countStr = w.get("lanes");
        if (countStr != null) {
            return Integer.parseInt(countStr);
        }
        return 2;
    }

    static int getRegularCount(Way w, Node end) {
        int count = Lane.getCount(w);
        if (w.hasDirectionKeys()) {
            if (w.lastNode().equals((Object)end)) {
                return count;
            }
            return 0;
        }
        if (w.lastNode().equals((Object)end)) {
            return (count + 1) / 2;
        }
        return count / 2;
    }

    public static List<Lane> load(Road r) {
        int i;
        Route.Segment first = r.getRoute().getFirstSegment();
        Route.Segment last = r.getRoute().getLastSegment();
        int back = Lane.getRegularCount(first.getWay(), first.getStart());
        int forth = Lane.getRegularCount(last.getWay(), last.getEnd());
        ArrayList<Lane> result = new ArrayList<Lane>(back + forth);
        for (i = back; i >= 1; --i) {
            result.add(new Lane(r, i, true));
        }
        for (i = 1; i <= forth; ++i) {
            result.add(new Lane(r, i, false));
        }
        return Collections.unmodifiableList(result);
    }

    public Lane(Road road, int index, boolean reverse) {
        this.road = road;
        this.index = index;
        this.kind = Kind.REGULAR;
        this.reverse = reverse;
        this.extraLength = -1.0;
    }

    public Lane(Road road, int index, boolean reverse, boolean left, double extraLength, double length) {
        this.road = road;
        this.index = index;
        this.kind = left ? Kind.EXTRA_LEFT : Kind.EXTRA_RIGHT;
        this.reverse = reverse;
        this.extraLength = extraLength;
        this.length = length;
        if (length <= 0.0) {
            throw new IllegalArgumentException("Length must be positive");
        }
        if (extraLength < 0.0) {
            throw new IllegalArgumentException("Extra length must not be negative");
        }
    }

    public Road getRoad() {
        return this.road;
    }

    public double getExtraLength() {
        return this.extraLength;
    }

    public Kind getKind() {
        return this.kind;
    }

    public double getLength() {
        return this.isExtra() ? this.length : this.road.getLength();
    }

    double getTotalLength() {
        if (!this.isExtra()) {
            throw new UnsupportedOperationException();
        }
        return this.length + this.extraLength;
    }

    public void setLength(double length) {
        if (!this.isExtra()) {
            throw new UnsupportedOperationException("Length can only be set for extra lanes.");
        }
        if (length <= 0.0) {
            throw new IllegalArgumentException("Length must positive.");
        }
        this.road.updateLengths();
        this.length = length;
    }

    public boolean isExtra() {
        return this.getKind() != Kind.REGULAR;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public Junction getOutgoingJunction() {
        return this.isReverse() ? this.getRoad().getFromEnd().getJunction() : this.getRoad().getToEnd().getJunction();
    }

    public Junction getIncomingJunction() {
        return this.isReverse() ? this.getRoad().getToEnd().getJunction() : this.getRoad().getFromEnd().getJunction();
    }

    public Road.End getOutgoingRoadEnd() {
        return this.isReverse() ? this.getRoad().getFromEnd() : this.getRoad().getToEnd();
    }

    public Road.End getIncomingRoadEnd() {
        return this.isReverse() ? this.getRoad().getToEnd() : this.getRoad().getFromEnd();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        EXTRA_LEFT,
        EXTRA_RIGHT,
        REGULAR;

    }
}

