/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Turn;
import org.openstreetmap.josm.plugins.turnlanes.model.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Junction {
    private final ModelContainer container;
    private final Node node;
    private final List<Road> roads = new ArrayList<Road>();

    private static final List<Way> filterHighways(List<OsmPrimitive> of) {
        ArrayList<Way> result = new ArrayList<Way>();
        for (OsmPrimitive p : of) {
            if (p.getType() != OsmPrimitiveType.WAY || !Utils.isRoad((Way)p)) continue;
            result.add((Way)p);
        }
        return result;
    }

    private static List<Way> filterBeginsOrEndsAt(List<Way> ways, Node node) {
        ArrayList<Way> result = new ArrayList<Way>();
        for (Way w : ways) {
            if (!w.isFirstLastNode(node)) continue;
            result.add(w);
        }
        return result;
    }

    private static List<Road> loadRoads(ModelContainer container, Junction j) {
        List<Way> ways = Junction.filterBeginsOrEndsAt(Junction.filterHighways(j.getNode().getReferrers()), j.getNode());
        return Road.map(container, ways, j);
    }

    Junction(ModelContainer container, Node n) {
        this.container = container;
        this.node = n;
        container.register(this);
        if (this.isPrimary()) {
            Junction.loadRoads(container, this);
            this.getTurns();
        }
    }

    boolean isPrimary() {
        return this.container.getPrimary().equals(this);
    }

    public Node getNode() {
        return this.node;
    }

    public List<Road> getRoads() {
        return this.roads;
    }

    void addRoad(Road r) {
        this.roads.add(r);
    }

    public void addTurn(Lane from, Road.End to) {
        assert (this.equals(from.getOutgoingJunction()));
        assert (this.equals(to.getJunction()));
        Way fromWay = from.isReverse() ? from.getRoad().getRoute().getFirstSegment().getWay() : from.getRoad().getRoute().getLastSegment().getWay();
        Way toWay = to.isFromEnd() ? to.getRoad().getRoute().getFirstSegment().getWay() : to.getRoad().getRoute().getLastSegment().getWay();
        Relation existing = null;
        for (Turn t : this.getTurns()) {
            if (!(from.isReverse() ? from.getRoad().getRoute().getFirstSegment() : from.getRoad().getRoute().getLastSegment()).getWay().equals((Object)t.getFromWay()) || !t.getTo().equals(to)) continue;
            if (t.getFrom().isExtra() == from.isExtra() && t.getFrom().getIndex() == from.getIndex()) {
                return;
            }
            existing = t.getRelation();
        }
        Relation r = existing == null ? new Relation() : existing;
        String key = from.isExtra() ? "lanes:extra" : "lanes";
        List<Integer> lanes = Turn.split(r.get(key));
        lanes.add(from.getIndex());
        r.put(key, Turn.join(lanes));
        if (existing == null) {
            r.put("type", "turnlanes:turns");
            r.addMember(new RelationMember("via", (OsmPrimitive)this.node));
            r.addMember(new RelationMember("from", (OsmPrimitive)fromWay));
            r.addMember(new RelationMember("to", (OsmPrimitive)toWay));
            this.node.getDataSet().addPrimitive((OsmPrimitive)r);
        }
    }

    public Set<Turn> getTurns() {
        return Turn.load(this);
    }

    Road.End getRoadEnd(Way way) {
        ArrayList<Road.End> candidates = new ArrayList<Road.End>();
        for (Road r : this.getRoads()) {
            if (r.getFromEnd().getJunction().equals(this) && r.getRoute().getSegments().get(0).getWay().equals((Object)way)) {
                candidates.add(r.getFromEnd());
            }
            if (!r.getToEnd().getJunction().equals(this) || !r.getRoute().getSegments().get(r.getRoute().getSegments().size() - 1).getWay().equals((Object)way)) continue;
            candidates.add(r.getToEnd());
        }
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("No such road end.");
        }
        if (candidates.size() > 1) {
            throw new IllegalArgumentException("There are " + candidates.size() + " road ends at this junction for the given way.");
        }
        return (Road.End)candidates.get(0);
    }

    public void removeTurn(Turn turn) {
        turn.remove();
    }
}

