/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiUtil;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionPane;
import org.openstreetmap.josm.plugins.turnlanes.gui.ValidationPanel;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;
import org.openstreetmap.josm.tools.I18n;

public class TurnLanesDialog
extends ToggleDialog {
    private final Action editAction = new JosmAction(I18n.tr((String)"Edit"), "dialogs/edit", I18n.tr((String)"Edit turn relations and lane lengths for selected node."), null, true){
        private static final long serialVersionUID = 4114119073563457706L;

        public void actionPerformed(ActionEvent e) {
            CardLayout cl = (CardLayout)TurnLanesDialog.this.body.getLayout();
            cl.show(TurnLanesDialog.this.body, TurnLanesDialog.CARD_EDIT);
            TurnLanesDialog.this.editing = true;
        }
    };
    private final Action validateAction = new JosmAction(I18n.tr((String)"Validate"), "dialogs/validator", I18n.tr((String)"Validate turn- and lane-length-relations for consistency."), null, true){
        private static final long serialVersionUID = 7510740945725851427L;

        public void actionPerformed(ActionEvent e) {
            CardLayout cl = (CardLayout)TurnLanesDialog.this.body.getLayout();
            cl.show(TurnLanesDialog.this.body, TurnLanesDialog.CARD_VALIDATE);
            TurnLanesDialog.this.editing = false;
        }
    };
    private static final long serialVersionUID = -1998375221636611358L;
    private static final String CARD_EDIT = "EDIT";
    private static final String CARD_VALIDATE = "VALIDATE";
    private static final String CARD_ERROR = "ERROR";
    private final JPanel body = new JPanel();
    private final JunctionPane junctionPane = new JunctionPane(null);
    private final JLabel error = new JLabel();
    private boolean editing = true;

    public TurnLanesDialog() {
        super(I18n.tr((String)"Turn Lanes"), "turnlanes.png", I18n.tr((String)"Edit turn lanes"), null, 200);
        DataSet.addSelectionListener((SelectionChangedListener)new SelectionChangedListener(){

            public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
                if (newSelection.size() != 1) {
                    return;
                }
                OsmPrimitive p = newSelection.iterator().next();
                if (p.getType() == OsmPrimitiveType.NODE) {
                    Junction j;
                    Node n = (Node)p;
                    try {
                        ModelContainer mc = ModelContainer.create(n);
                        j = mc.getJunction(n);
                    }
                    catch (RuntimeException e) {
                        TurnLanesDialog.this.displayError(e);
                        return;
                    }
                    EastNorth en = Main.proj.latlon2eastNorth(n.getCoor());
                    EastNorth rel = new EastNorth(en.getX() + 1.0, en.getY());
                    double mpsu = Main.proj.eastNorth2latlon(rel).greatCircleDistance(n.getCoor());
                    GuiContainer model = new GuiContainer(GuiUtil.loc(n), mpsu);
                    TurnLanesDialog.this.setJunction(model.getGui(j));
                }
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 4, 4));
        buttonPanel.add((Component)new SideButton(this.editAction));
        buttonPanel.add((Component)new SideButton(this.validateAction));
        this.body.setLayout(new CardLayout(4, 4));
        this.add(buttonPanel, "South");
        this.add(this.body, "Center");
        this.body.add((Component)this.junctionPane, CARD_EDIT);
        this.body.add((Component)new ValidationPanel(), CARD_VALIDATE);
        this.body.add((Component)this.error, CARD_ERROR);
        this.editAction.actionPerformed(null);
    }

    void displayError(RuntimeException e) {
        if (this.editing) {
            this.error.setText("<html>An error occured while constructing the model. Please run the validator to make sure the data is consistent.<br><br>Error: " + e.getMessage() + "</html>");
            CardLayout cl = (CardLayout)this.body.getLayout();
            cl.show(this.body, CARD_ERROR);
        }
    }

    void setJunction(JunctionGui j) {
        if (j != null && this.editing) {
            this.junctionPane.setJunction(j);
            CardLayout cl = (CardLayout)this.body.getLayout();
            cl.show(this.body, CARD_EDIT);
        }
    }
}

