/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.LaneGui;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;

interface State {
    public JunctionGui getJunction();

    public static class OutgoingActive
    implements State {
        private final JunctionGui junction;
        private final LaneGui lane;

        public OutgoingActive(JunctionGui junction, LaneGui lane) {
            this.junction = junction;
            this.lane = lane;
        }

        public LaneGui getLane() {
            return this.lane;
        }

        public JunctionGui getJunction() {
            return this.junction;
        }
    }

    public static class IncomingActive
    implements State {
        private final JunctionGui junction;
        private final Road.End roadEnd;

        public IncomingActive(JunctionGui junction, Road.End roadEnd) {
            this.junction = junction;
            this.roadEnd = roadEnd;
        }

        public Road.End getRoadEnd() {
            return this.roadEnd;
        }

        public JunctionGui getJunction() {
            return this.junction;
        }
    }

    public static class Default
    implements State {
        private final JunctionGui junction;

        public Default(JunctionGui junction) {
            this.junction = junction;
        }

        public JunctionGui getJunction() {
            return this.junction;
        }
    }

    public static class Dirty
    implements State {
        private final State wrapped;

        public Dirty(State wrapped) {
            this.wrapped = wrapped;
        }

        public JunctionGui getJunction() {
            return this.wrapped.getJunction();
        }

        public State unwrap() {
            return this.wrapped;
        }
    }

    public static class Invalid
    implements State {
        private final State wrapped;

        public Invalid(State wrapped) {
            this.wrapped = wrapped;
        }

        public JunctionGui getJunction() {
            return this.wrapped.getJunction();
        }

        public State unwrap() {
            return this.wrapped;
        }
    }
}

