/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.InteractiveElement;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.RoadGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.State;
import org.openstreetmap.josm.plugins.turnlanes.model.ModelContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JunctionPane
extends JComponent {
    private static final long serialVersionUID = 6917061040674799271L;
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private final MouseInputProcessor mip = new MouseInputProcessor();
    private JunctionGui junction;
    private int width = 0;
    private int height = 0;
    private double scale = 10.0;
    private double translationX = 0.0;
    private double translationY = 0.0;
    private boolean dirty = true;
    private BufferedImage passive;
    private BufferedImage interactive;
    private final NavigableMap<Integer, List<InteractiveElement>> interactives = new TreeMap<Integer, List<InteractiveElement>>();
    private State state;
    private InteractiveElement dragging;

    public JunctionPane(JunctionGui junction) {
        this.setJunction(junction);
    }

    public void setJunction(JunctionGui junction) {
        this.removeMouseListener(this.mip);
        this.removeMouseMotionListener(this.mip);
        this.removeMouseWheelListener(this.mip);
        this.interactives.clear();
        this.dragging = null;
        this.junction = junction;
        this.dirty = true;
        this.repaint();
        if (junction == null) {
            this.state = null;
        } else {
            this.state = new State.Default(junction);
            Rectangle2D bounds = junction.getBounds();
            this.scale = Math.min((double)(this.getHeight() / 2) / bounds.getHeight(), (double)(this.getWidth() / 2) / bounds.getWidth());
            this.translationX = -bounds.getCenterX();
            this.translationY = -bounds.getCenterY();
            this.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
            this.addMouseListener(this.mip);
            this.addMouseMotionListener(this.mip);
            this.addMouseWheelListener(this.mip);
        }
    }

    private void setState(State state) {
        if (state instanceof State.Invalid) {
            Node n = this.junction.getModel().getNode();
            ModelContainer m = ModelContainer.create(n);
            GuiContainer c = this.junction.getContainer().empty();
            this.junction = c.getGui(m.getJunction(n));
            this.dirty = true;
            this.state = new State.Default(this.junction);
        } else if (state instanceof State.Dirty) {
            this.dirty = true;
            this.state = ((State.Dirty)state).unwrap();
        } else {
            this.state = state;
        }
    }

    void scale(int x, int y, double scale) {
        this.scale *= scale;
        double w = this.getWidth();
        double h = this.getHeight();
        this.translationX -= w * (scale - 1.0) / (2.0 * this.scale);
        this.translationY -= h * (scale - 1.0) / (2.0 * this.scale);
        this.dirty = true;
        this.repaint();
    }

    void translate(double x, double y) {
        this.translationX += x / this.scale;
        this.translationY += y / this.scale;
        this.dirty = true;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getWidth() != this.width || this.getHeight() != this.height) {
            this.translate((double)(this.getWidth() - this.width) / 2.0, (double)(this.getHeight() - this.height) / 2.0);
            this.width = this.getWidth();
            this.height = this.getHeight();
            this.passive = new BufferedImage(this.width, this.height, 5);
            this.interactive = new BufferedImage(this.width, this.height, 2);
        }
        if (this.junction == null) {
            super.paintComponent(g);
            return;
        }
        if (this.dirty) {
            this.paintPassive((Graphics2D)this.passive.getGraphics());
            this.dirty = false;
        }
        this.paintInteractive((Graphics2D)this.interactive.getGraphics());
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage(this.passive, 0, 0, this.getWidth(), this.getHeight(), null);
        g2d.drawImage(this.interactive, 0, 0, this.getWidth(), this.getHeight(), null);
    }

    private void paintInteractive(Graphics2D g2d) {
        g2d.setBackground(TRANSPARENT);
        g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.scale(this.scale, this.scale);
        g2d.translate(this.translationX, this.translationY);
        g2d.setComposite(AlphaComposite.getInstance(2, 0.7f));
        for (Map.Entry e : this.interactives.entrySet()) {
            for (InteractiveElement ie : (List)e.getValue()) {
                ie.paintBackground(g2d, this.state);
            }
            for (InteractiveElement ie : (List)e.getValue()) {
                ie.paint(g2d, this.state);
            }
        }
    }

    private List<InteractiveElement> interactives() {
        ArrayList<InteractiveElement> result = new ArrayList<InteractiveElement>();
        for (List ies : this.interactives.descendingMap().values()) {
            result.addAll(ies);
        }
        return result;
    }

    private void paintPassive(Graphics2D g2d) {
        this.interactives.clear();
        g2d.setBackground(new Color(100, 160, 240));
        g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2d.scale(this.scale, this.scale);
        g2d.translate(this.translationX, this.translationY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.GRAY);
        for (RoadGui r : this.junction.getRoads()) {
            this.addAllInteractives(r.paint(g2d));
        }
        this.addAllInteractives(this.junction.paint(g2d));
        JunctionPane.dot(g2d, new Point2D.Double(this.junction.x, this.junction.y), this.junction.getContainer().getLaneWidth() / 5.0);
    }

    private void addAllInteractives(List<InteractiveElement> ies) {
        for (InteractiveElement ie : ies) {
            ArrayList<InteractiveElement> list;
            ArrayList<InteractiveElement> existing = (ArrayList<InteractiveElement>)this.interactives.get(ie.getZIndex());
            if (existing == null) {
                list = new ArrayList<InteractiveElement>();
                this.interactives.put(ie.getZIndex(), list);
            } else {
                list = existing;
            }
            list.add(ie);
        }
    }

    static void dot(Graphics2D g2d, Point2D p, double r, Color c) {
        Color old = g2d.getColor();
        g2d.setColor(c);
        g2d.fill(new Ellipse2D.Double(p.getX() - r, p.getY() - r, 2.0 * r, 2.0 * r));
        g2d.setColor(old);
    }

    static void dot(Graphics2D g2d, Point2D p, double r) {
        JunctionPane.dot(g2d, p, r, Color.RED);
    }

    private final class MouseInputProcessor
    extends MouseAdapter {
        private int originX;
        private int originY;
        private int button;

        private MouseInputProcessor() {
        }

        public void mousePressed(MouseEvent e) {
            this.button = e.getButton();
            if (this.button == 1) {
                Point2D mouse = this.translateMouseCoords(e);
                for (InteractiveElement ie : JunctionPane.this.interactives()) {
                    if (!ie.contains(mouse, JunctionPane.this.state)) continue;
                    JunctionPane.this.setState(ie.activate(JunctionPane.this.state));
                    JunctionPane.this.repaint();
                    break;
                }
            }
            this.originX = e.getX();
            this.originY = e.getY();
        }

        public void mouseReleased(MouseEvent e) {
            if (JunctionPane.this.dragging != null) {
                Point2D mouse = this.translateMouseCoords(e);
                JunctionPane.this.setState(JunctionPane.this.dragging.drop(mouse.getX(), mouse.getY(), this.dropTarget(mouse), JunctionPane.this.state));
            }
            JunctionPane.this.dragging = null;
            JunctionPane.this.repaint();
        }

        private InteractiveElement dropTarget(Point2D mouse) {
            for (InteractiveElement ie : JunctionPane.this.interactives()) {
                if (!ie.contains(mouse, JunctionPane.this.state)) continue;
                return ie;
            }
            return null;
        }

        public void mouseClicked(MouseEvent e) {
            if (this.button == 1) {
                Point2D mouse = this.translateMouseCoords(e);
                for (InteractiveElement ie : JunctionPane.this.interactives()) {
                    if (!ie.contains(mouse, JunctionPane.this.state)) continue;
                    JunctionPane.this.setState(ie.click(JunctionPane.this.state));
                    JunctionPane.this.repaint();
                    break;
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.button == 1) {
                Point2D mouse = this.translateMouseCoords(e);
                if (JunctionPane.this.dragging == null) {
                    Point2D origin = this.translateCoords(this.originX, this.originY);
                    for (InteractiveElement ie : JunctionPane.this.interactives()) {
                        if (!ie.contains(origin, JunctionPane.this.state)) continue;
                        if (!ie.beginDrag(origin.getX(), origin.getY())) break;
                        JunctionPane.this.dragging = ie;
                        break;
                    }
                }
                if (JunctionPane.this.dragging != null) {
                    JunctionPane.this.setState(JunctionPane.this.dragging.drag(mouse.getX(), mouse.getY(), this.dropTarget(mouse), JunctionPane.this.state));
                }
                JunctionPane.this.repaint();
            } else if (this.button == 3) {
                JunctionPane.this.translate(e.getX() - this.originX, e.getY() - this.originY);
                this.originX = e.getX();
                this.originY = e.getY();
            }
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            JunctionPane.this.scale(e.getX(), e.getY(), Math.pow(0.8, e.getWheelRotation()));
        }

        private Point2D translateMouseCoords(MouseEvent e) {
            return this.translateCoords(e.getX(), e.getY());
        }

        private Point2D translateCoords(int x, int y) {
            return new Point2D.Double(-JunctionPane.this.translationX + (double)x / JunctionPane.this.scale, -JunctionPane.this.translationY + (double)y / JunctionPane.this.scale);
        }
    }
}

