/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiContainer;
import org.openstreetmap.josm.plugins.turnlanes.gui.GuiUtil;
import org.openstreetmap.josm.plugins.turnlanes.gui.InteractiveElement;
import org.openstreetmap.josm.plugins.turnlanes.gui.LaneGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.RoadGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.State;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;
import org.openstreetmap.josm.plugins.turnlanes.model.Turn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JunctionGui {
    private static final double MAX_ANGLE = Math.toRadians(30.0);
    private final GuiContainer container;
    private final Junction junction;
    final double x;
    final double y;
    private final NavigableMap<Double, Linkage> roads = new TreeMap<Double, Linkage>();
    private final Path2D area = new Path2D.Double();

    public JunctionGui(GuiContainer container, Junction j) {
        this.container = container;
        this.junction = j;
        container.register(this);
        Point2D loc = container.translateAndScale(GuiUtil.loc(j.getNode()));
        this.x = loc.getX();
        this.y = loc.getY();
        HashSet<Road> done = new HashSet<Road>();
        for (Road r : j.getRoads()) {
            if (done.contains(r)) continue;
            done.add(r);
            if (r.getFromEnd().getJunction().equals(j)) {
                new Linkage(r.getFromEnd());
            }
            if (!r.getToEnd().getJunction().equals(j)) continue;
            new Linkage(r.getToEnd());
        }
        this.recalculate();
    }

    void recalculate() {
        for (Linkage l : this.roads.values()) {
            l.lTrim = 0.0;
            l.rTrim = 0.0;
        }
        this.area.reset();
        if (this.roads.size() < 2) {
            return;
        }
        Linkage last = this.roads.lastEntry().getValue();
        for (Linkage l : this.roads.values()) {
            l.trimLeft(last);
            last = l;
        }
        for (Linkage l : this.roads.values()) {
            l.trimAdjust();
        }
        boolean first = true;
        for (Corner c : this.corners()) {
            if (first) {
                this.area.moveTo(c.x1, c.y1);
                first = false;
            } else {
                this.area.lineTo(c.x1, c.y1);
            }
            this.area.curveTo(c.cx1, c.cy1, c.cx2, c.cy2, c.x2, c.y2);
        }
        this.area.closePath();
    }

    private Iterable<Corner> corners() {
        ArrayList<Corner> result = new ArrayList<Corner>(this.roads.size());
        Linkage last = this.roads.lastEntry().getValue();
        for (Linkage l : this.roads.values()) {
            result.add(this.corner(last, l));
            last = l;
        }
        return result;
    }

    private Corner corner(Linkage right, Linkage left) {
        Line2D rightCurb = right.roadGui.getRightCurb(right.roadEnd);
        Line2D leftCurb = left.roadGui.getLeftCurb(left.roadEnd);
        double rightAngle = GuiUtil.angle(rightCurb);
        double leftAngle = GuiUtil.angle(leftCurb);
        double delta = GuiUtil.normalize(leftAngle - rightAngle);
        boolean wide = delta > Math.PI;
        double a = wide ? Math.max(0.0, delta - (Math.PI + 2.0 * MAX_ANGLE)) : delta;
        double cpf1 = GuiUtil.cpf(a, this.container.getLaneWidth() / 2.0 + (wide ? right.roadGui.getWidth(right.roadEnd) : 0.0));
        double cpf2 = GuiUtil.cpf(a, this.container.getLaneWidth() / 2.0 + (wide ? left.roadGui.getWidth(left.roadEnd) : 0.0));
        Point2D c1 = GuiUtil.relativePoint(rightCurb.getP1(), cpf1, right.angle + Math.PI);
        Point2D c2 = GuiUtil.relativePoint(leftCurb.getP1(), cpf2, left.angle + Math.PI);
        return new Corner(rightCurb.getP1(), c1, c2, leftCurb.getP1());
    }

    public Set<RoadGui> getRoads() {
        HashSet<RoadGui> result = new HashSet<RoadGui>();
        for (Linkage l : this.roads.values()) {
            result.add(l.roadGui);
        }
        return Collections.unmodifiableSet(result);
    }

    double getLeftTrim(Road.End end) {
        return this.getLinkage((Road.End)end).lTrim;
    }

    private Linkage getLinkage(Road.End end) {
        double a = GuiUtil.normalize(this.getContainer().getGui(end.getRoad()).getAngle(end) + Math.PI);
        Map.Entry<Double, Linkage> e = this.roads.floorEntry(a);
        return e != null ? e.getValue() : null;
    }

    double getRightTrim(Road.End end) {
        return this.getLinkage((Road.End)end).rTrim;
    }

    Point2D getPoint() {
        return new Point2D.Double(this.x, this.y);
    }

    public GuiContainer getContainer() {
        return this.container;
    }

    public Junction getModel() {
        return this.junction;
    }

    public List<InteractiveElement> paint(Graphics2D g2d) {
        g2d.setColor(new Color(96, 96, 96));
        g2d.fill(this.area);
        ArrayList<InteractiveElement> result = new ArrayList<InteractiveElement>();
        for (Turn t : this.getModel().getTurns()) {
            result.add(new TurnConnection(t));
        }
        return result;
    }

    public Rectangle2D getBounds() {
        return this.area.getBounds2D();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Linkage
    implements Comparable<Linkage> {
        final RoadGui roadGui;
        final Road.End roadEnd;
        final double angle;
        double lTrim;
        double rTrim;

        public Linkage(Road.End roadEnd) {
            this.roadGui = JunctionGui.this.getContainer().getGui(roadEnd.getRoad());
            this.roadEnd = roadEnd;
            this.angle = GuiUtil.normalize(this.roadGui.getAngle(roadEnd) + Math.PI);
            JunctionGui.this.roads.put(this.angle, this);
        }

        @Override
        public int compareTo(Linkage o) {
            return Double.compare(this.angle, o.angle);
        }

        public void trimLeft(Linkage right) {
            right.trimRight(this);
            Line2D leftCurb = this.roadGui.getLeftCurb(this.roadEnd);
            Line2D rightCurb = right.roadGui.getRightCurb(right.roadEnd);
            double leftAngle = GuiUtil.angle(leftCurb);
            double rightAngle = GuiUtil.angle(rightCurb);
            Point2D isect = Math.abs(Math.PI - GuiUtil.normalize(rightAngle - leftAngle)) > 0.2617993877991494 ? GuiUtil.intersection(leftCurb, rightCurb) : GuiUtil.relativePoint(leftCurb.getP1(), this.roadGui.getWidth(this.roadEnd) / 2.0, this.angle);
            if (Math.abs(leftAngle - GuiUtil.angle(leftCurb.getP1(), isect)) < 0.1) {
                this.lTrim = leftCurb.getP1().distance(isect);
            }
        }

        private void trimRight(Linkage left) {
            double leftAngle;
            Line2D rightCurb = this.roadGui.getRightCurb(this.roadEnd);
            Line2D leftCurb = left.roadGui.getLeftCurb(left.roadEnd);
            double rightAngle = GuiUtil.angle(rightCurb);
            Point2D isect = Math.abs(Math.PI - GuiUtil.normalize(rightAngle - (leftAngle = GuiUtil.angle(leftCurb)))) > 0.2617993877991494 ? GuiUtil.intersection(rightCurb, leftCurb) : GuiUtil.relativePoint(rightCurb.getP1(), this.roadGui.getWidth(this.roadEnd) / 2.0, this.angle);
            if (Math.abs(rightAngle - GuiUtil.angle(rightCurb.getP1(), isect)) < 0.1) {
                this.rTrim = rightCurb.getP1().distance(isect);
            }
        }

        public void trimAdjust() {
            double cos;
            double MAX_TAN = Math.tan(1.5707963267948966 - MAX_ANGLE);
            double sin = this.roadGui.getWidth(this.roadEnd);
            double tan = sin / (cos = Math.abs(this.lTrim - this.rTrim));
            if (tan < MAX_TAN) {
                this.lTrim = Math.max(this.lTrim, this.rTrim - sin / MAX_TAN);
                this.rTrim = Math.max(this.rTrim, this.lTrim - sin / MAX_TAN);
            }
            this.lTrim += JunctionGui.this.container.getLaneWidth() / 2.0;
            this.rTrim += JunctionGui.this.container.getLaneWidth() / 2.0;
        }
    }

    private final class Corner {
        final double x1;
        final double y1;
        final double cx1;
        final double cy1;
        final double cx2;
        final double cy2;
        final double x2;
        final double y2;

        public Corner(Point2D c1, Point2D cp1, Point2D cp2, Point2D c2) {
            this.x1 = c1.getX();
            this.y1 = c1.getY();
            this.cx1 = cp1.getX();
            this.cy1 = cp1.getY();
            this.cx2 = cp2.getX();
            this.cy2 = cp2.getY();
            this.x2 = c2.getX();
            this.y2 = c2.getY();
        }

        public String toString() {
            return "Corner [x1=" + this.x1 + ", y1=" + this.y1 + ", cx1=" + this.cx1 + ", cy1=" + this.cy1 + ", cx2=" + this.cx2 + ", cy2=" + this.cy2 + ", x2=" + this.x2 + ", y2=" + this.y2 + "]";
        }
    }

    private final class TurnConnection
    extends InteractiveElement {
        private final Turn turn;
        private final Line2D line = new Line2D.Double();
        private Point2D dragBegin;
        private Point2D dragOffset = new Point2D.Double();

        public TurnConnection(Turn turn) {
            this.turn = turn;
        }

        void paint(Graphics2D g2d, State state) {
            if (this.isVisible(state)) {
                LaneGui laneGui = JunctionGui.this.getContainer().getGui(this.turn.getFrom());
                RoadGui roadGui = JunctionGui.this.getContainer().getGui(this.turn.getTo().getRoad());
                g2d.setStroke(JunctionGui.this.getContainer().getConnectionStroke());
                g2d.setColor(this.isRemoveDragOffset() ? GuiContainer.RED : GuiContainer.GREEN);
                this.line.setLine(laneGui.outgoing.getCenter(), roadGui.getConnector(this.turn.getTo()).getCenter());
                this.line.setLine(this.line.getX1() + this.dragOffset.getX(), this.line.getY1() + this.dragOffset.getY(), this.line.getX2() + this.dragOffset.getX(), this.line.getY2() + this.dragOffset.getY());
                g2d.draw(this.line);
            }
        }

        private boolean isVisible(State state) {
            if (state instanceof State.OutgoingActive) {
                return this.turn.getFrom().equals(((State.OutgoingActive)state).getLane().getModel());
            }
            if (state instanceof State.IncomingActive) {
                return this.turn.getTo().equals(((State.IncomingActive)state).getRoadEnd());
            }
            return false;
        }

        boolean contains(Point2D p, State state) {
            Point2D closest = GuiUtil.closest(this.line, p);
            return p.distance(closest) <= this.strokeWidth() / 2.0;
        }

        private double strokeWidth() {
            BasicStroke stroke = (BasicStroke)JunctionGui.this.getContainer().getConnectionStroke();
            return stroke.getLineWidth();
        }

        InteractiveElement.Type getType() {
            return InteractiveElement.Type.TURN_CONNECTION;
        }

        int getZIndex() {
            return 0;
        }

        boolean beginDrag(double x, double y) {
            this.dragBegin = new Point2D.Double(x, y);
            this.dragOffset = new Point2D.Double();
            return true;
        }

        State drag(double x, double y, InteractiveElement target, State old) {
            this.dragOffset = new Point2D.Double(x - this.dragBegin.getX(), y - this.dragBegin.getY());
            return old;
        }

        State drop(double x, double y, InteractiveElement target, State old) {
            this.drag(x, y, target, old);
            if (this.isRemoveDragOffset()) {
                JunctionGui.this.getModel().removeTurn(this.turn);
            }
            this.dragOffset = new Point2D.Double();
            return new State.Dirty(old);
        }

        private boolean isRemoveDragOffset() {
            double r = JunctionGui.this.getContainer().getGui((Road)this.turn.getFrom().getRoad()).connectorRadius;
            double max = r - this.strokeWidth() / 2.0;
            return this.dragOffset.distance(0.0, 0.0) > max;
        }
    }
}

