/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanes.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.plugins.turnlanes.gui.JunctionGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.LaneGui;
import org.openstreetmap.josm.plugins.turnlanes.gui.RoadGui;
import org.openstreetmap.josm.plugins.turnlanes.model.Junction;
import org.openstreetmap.josm.plugins.turnlanes.model.Lane;
import org.openstreetmap.josm.plugins.turnlanes.model.Road;

class GuiContainer {
    static final Color RED = new Color(234, 66, 108);
    static final Color GREEN = new Color(66, 234, 108);
    private final Point2D translation;
    private final double mpp;
    private final double mpsu;
    private final double scale;
    private final double laneWidth;
    private final Map<Junction, JunctionGui> junctions = new HashMap<Junction, JunctionGui>();
    private final Map<Road, RoadGui> roads = new HashMap<Road, RoadGui>();
    private final Stroke connectionStroke;

    public GuiContainer(Point2D origin, double mpsu) {
        this.translation = new Point2D.Double(-origin.getX(), -origin.getY());
        this.mpp = 0.2;
        this.mpsu = mpsu;
        this.scale = mpsu / this.mpp;
        this.laneWidth = 2.0 / this.mpp;
        this.connectionStroke = new BasicStroke((float)(this.laneWidth / 4.0), 1, 1);
    }

    public JunctionGui getGui(Junction j) {
        JunctionGui existing = this.junctions.get(j);
        if (existing != null) {
            return existing;
        }
        return new JunctionGui(this, j);
    }

    void register(JunctionGui j) {
        if (this.junctions.put(j.getModel(), j) != null) {
            throw new IllegalStateException();
        }
    }

    public RoadGui getGui(Road r) {
        RoadGui gui = this.roads.get(r);
        if (gui == null) {
            RoadGui newGui = new RoadGui(this, r);
            this.roads.put(r, newGui);
            return newGui;
        }
        return gui;
    }

    Point2D translateAndScale(Point2D loc) {
        return new Point2D.Double((loc.getX() + this.translation.getX()) * this.scale, (loc.getY() + this.translation.getY()) * this.scale);
    }

    public double getMpp() {
        return this.mpp;
    }

    public double getScale() {
        return this.scale;
    }

    public double getLaneWidth() {
        return this.laneWidth;
    }

    public Stroke getConnectionStroke() {
        return this.connectionStroke;
    }

    public LaneGui getGui(Lane lane) {
        RoadGui roadGui = this.roads.get(lane.getRoad());
        for (LaneGui l : roadGui.getLanes()) {
            if (!l.getModel().equals(lane)) continue;
            return l;
        }
        throw new IllegalArgumentException("No such lane.");
    }

    public GuiContainer empty() {
        return new GuiContainer(new Point2D.Double(-this.translation.getX(), -this.translation.getY()), this.mpsu);
    }
}

