/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.util.retry;

import org.openstreetmap.josm.plugins.mapdust.util.retry.RetryMode;
import org.openstreetmap.josm.plugins.mapdust.util.retry.RetrySetup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RetryAgent<T> {
    private RetrySetup setup;

    public RetryAgent() {
        this(RetrySetup.DEFAULT);
    }

    public RetryAgent(RetrySetup setup) {
        this.setup = setup;
    }

    protected abstract T target() throws Exception;

    protected abstract void cleanup() throws Exception;

    public T run() throws Exception {
        T result;
        if (this.setup.getMode() == RetryMode.COUNTED) {
            result = this.runCounted();
        } else if (this.setup.getMode() == RetryMode.TIMED) {
            result = this.runTimed();
        } else {
            throw new RuntimeException("Unsupported retry mode: '" + (Object)((Object)this.setup.getMode()) + "'");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T runCounted() throws Exception {
        T result = null;
        boolean success = false;
        int attempts = this.setup.getStopCondition();
        int delay = this.setup.getBaseDelay();
        do {
            --attempts;
            try {
                result = this.target();
                success = true;
            }
            catch (Exception e) {
                if (attempts <= 0) {
                    throw e;
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                delay = delay * 3 / 2;
            }
            finally {
                try {
                    this.cleanup();
                }
                catch (Exception e) {}
            }
        } while (!success && attempts > 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T runTimed() throws Exception {
        T result = null;
        boolean success = false;
        int delay = this.setup.getBaseDelay();
        int maxTime = this.setup.getStopCondition();
        do {
            long time = System.currentTimeMillis();
            try {
                result = this.target();
                success = true;
            }
            catch (Exception e) {
                if (maxTime - delay <= 0) {
                    throw e;
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e1) {
                    throw e;
                }
                delay = delay * 3 / 2;
            }
            finally {
                try {
                    this.cleanup();
                }
                catch (Exception e) {}
            }
            time = System.currentTimeMillis() - time;
            maxTime = (int)((long)maxTime - time);
        } while (!success && maxTime > 0);
        return result;
    }
}

