/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.service.connector;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.plugins.mapdust.service.connector.MapdustConnectorException;
import org.openstreetmap.josm.plugins.mapdust.service.connector.parser.MapdustParser;
import org.openstreetmap.josm.plugins.mapdust.service.connector.parser.MapdustParserException;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustGetBugResponse;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustGetBugsResponse;
import org.openstreetmap.josm.plugins.mapdust.service.connector.response.MapdustPostResponse;
import org.openstreetmap.josm.plugins.mapdust.service.value.BoundingBox;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBugFilter;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustComment;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustResponseStatusCode;
import org.openstreetmap.josm.plugins.mapdust.service.value.Paging;
import org.openstreetmap.josm.plugins.mapdust.util.Configuration;
import org.openstreetmap.josm.plugins.mapdust.util.http.HttpConnector;
import org.openstreetmap.josm.plugins.mapdust.util.http.HttpResponse;
import org.openstreetmap.josm.plugins.mapdust.util.retry.RetrySetup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapdustConnector {
    private final HttpConnector httpConnector;
    private final MapdustParser parser;

    public MapdustConnector() {
        this.httpConnector = new HttpConnector(RetrySetup.DEFAULT);
        this.parser = new MapdustParser();
    }

    public MapdustConnector(HttpConnector httpConnector, MapdustParser parser) {
        this.httpConnector = httpConnector;
        this.parser = parser;
    }

    public MapdustGetBugsResponse getBugs(BoundingBox bBox, MapdustBugFilter filter) throws MapdustConnectorException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.executeGetBugs(bBox, filter);
        }
        catch (MalformedURLException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        MapdustGetBugsResponse result = null;
        try {
            this.handleStatusCode(httpResponse);
            result = (MapdustGetBugsResponse)this.getParser().parseResponse(httpResponse.getContent(), MapdustGetBugsResponse.class);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (MapdustParserException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        return result;
    }

    public MapdustGetBugResponse getBug(Long id, Paging paging) throws MapdustConnectorException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.executeGetBug(id, paging);
        }
        catch (MalformedURLException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        MapdustGetBugResponse result = null;
        try {
            this.handleStatusCode(httpResponse);
            result = (MapdustGetBugResponse)this.getParser().parseResponse(httpResponse.getContent(), MapdustGetBugResponse.class);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (MapdustParserException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        return result;
    }

    public MapdustPostResponse addBug(MapdustBug bug) throws MapdustConnectorException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.executeAddBug(bug);
        }
        catch (MalformedURLException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        MapdustPostResponse result = null;
        try {
            this.handleStatusCode(httpResponse);
            result = (MapdustPostResponse)this.getParser().parseResponse(httpResponse.getContent(), MapdustPostResponse.class);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (MapdustParserException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        return result;
    }

    public MapdustPostResponse commentBug(MapdustComment comment) throws MapdustConnectorException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.executeCommentBug(comment);
        }
        catch (MalformedURLException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        MapdustPostResponse result = null;
        try {
            this.handleStatusCode(httpResponse);
            result = (MapdustPostResponse)this.getParser().parseResponse(httpResponse.getContent(), MapdustPostResponse.class);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (MapdustParserException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        return result;
    }

    public MapdustPostResponse changeBugStatus(Integer statusId, MapdustComment comment) throws MapdustConnectorException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.executeChangeBugStatus(statusId, comment);
        }
        catch (MalformedURLException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        MapdustPostResponse result = null;
        try {
            this.handleStatusCode(httpResponse);
            result = (MapdustPostResponse)this.getParser().parseResponse(httpResponse.getContent(), MapdustPostResponse.class);
        }
        catch (MapdustConnectorException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        catch (MapdustParserException e) {
            throw new MapdustConnectorException(e.getMessage(), e);
        }
        return result;
    }

    private HttpResponse executeGetBugs(BoundingBox bBox, MapdustBugFilter filter) throws MalformedURLException, IOException {
        HttpResponse httpResponse = null;
        String mapdustUri = Configuration.getInstance().getMapdustUrl();
        String mapdustApiKey = Configuration.getInstance().getMapdustKey();
        String urlString = null;
        if (mapdustUri != null && mapdustApiKey != null) {
            urlString = mapdustUri;
            urlString = urlString + "/getBugs?";
            urlString = urlString + "key=" + mapdustApiKey;
            urlString = urlString + "&bbox=" + bBox.getMinLon();
            urlString = urlString + "," + bBox.getMinLat();
            urlString = urlString + "," + bBox.getMaxLon();
            urlString = urlString + "," + bBox.getMaxLat();
            if (filter != null) {
                String paramTypes;
                String paramStatus;
                if (filter.getStatuses() != null && filter.getStatuses().size() > 0 && !(paramStatus = this.buildParameter(filter.getStatuses())).isEmpty()) {
                    urlString = urlString + "&fs=" + paramStatus;
                }
                if (filter.getTypes() != null && filter.getTypes().size() > 0 && !(paramTypes = this.buildParameter(filter.getTypes())).isEmpty()) {
                    urlString = urlString + "&ft=" + paramTypes;
                }
                if (filter.getDescr() != null && filter.getDescr().booleanValue()) {
                    urlString = urlString + "&idd=0";
                }
            }
        }
        URL url = null;
        if (urlString != null) {
            url = new URL(urlString);
            httpResponse = this.getHttpConnector().executeGET(url);
        }
        return httpResponse;
    }

    private HttpResponse executeGetBug(Long id, Paging paging) throws MalformedURLException, IOException {
        HttpResponse httpResponse = null;
        String mapdustUri = Configuration.getInstance().getMapdustUrl();
        String mapdustApiKey = Configuration.getInstance().getMapdustKey();
        String urlString = null;
        if (mapdustUri != null && mapdustApiKey != null) {
            urlString = mapdustUri;
            urlString = urlString + "/getBug?";
            urlString = urlString + "key=" + mapdustApiKey;
            if (id != null) {
                urlString = urlString + "&id=" + id;
            }
            if (paging != null && paging.getItems() != null && paging.getPage() != null) {
                urlString = urlString + "&items=" + paging.getItems();
                urlString = urlString + "&p=" + paging.getPage();
            }
        }
        URL url = null;
        if (urlString != null) {
            url = new URL(urlString);
            httpResponse = this.getHttpConnector().executeGET(url);
        }
        return httpResponse;
    }

    private HttpResponse executeAddBug(MapdustBug bug) throws MalformedURLException, IOException {
        HttpResponse httpResponse = null;
        String mapdustUri = Configuration.getInstance().getMapdustUrl();
        String mapdustApiKey = Configuration.getInstance().getMapdustKey();
        String urlString = null;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (mapdustUri != null && mapdustApiKey != null) {
            urlString = mapdustUri;
            urlString = urlString + "/addBug";
            requestParameters.put("key", mapdustApiKey);
            String coordinatesStr = "" + bug.getLatLon().getX();
            coordinatesStr = coordinatesStr + "," + bug.getLatLon().getY();
            requestParameters.put("coordinates", coordinatesStr);
            requestParameters.put("type", bug.getType().getKey());
            requestParameters.put("description", bug.getDescription());
            requestParameters.put("nickname", bug.getNickname());
        }
        URL url = null;
        if (urlString != null) {
            url = new URL(urlString);
            httpResponse = this.getHttpConnector().executePOST(url, null, requestParameters);
        }
        return httpResponse;
    }

    private HttpResponse executeCommentBug(MapdustComment comment) throws MalformedURLException, IOException {
        HttpResponse httpResponse = null;
        String mapdustUri = Configuration.getInstance().getMapdustUrl();
        String mapdustApiKey = Configuration.getInstance().getMapdustKey();
        String urlString = null;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (mapdustUri != null && mapdustApiKey != null) {
            urlString = mapdustUri;
            urlString = urlString + "/commentBug";
            requestParameters.put("key", mapdustApiKey);
            requestParameters.put("id", comment.getBugId().toString());
            requestParameters.put("comment", comment.getCommentText());
            requestParameters.put("nickname", comment.getNickname());
        }
        URL url = null;
        if (urlString != null) {
            url = new URL(urlString);
            httpResponse = this.getHttpConnector().executePOST(url, null, requestParameters);
        }
        return httpResponse;
    }

    private HttpResponse executeChangeBugStatus(Integer statusId, MapdustComment comment) throws MalformedURLException, IOException {
        HttpResponse httpResponse = null;
        String mapdustUri = Configuration.getInstance().getMapdustUrl();
        String mapdustApiKey = Configuration.getInstance().getMapdustKey();
        String urlString = null;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (mapdustUri != null && mapdustApiKey != null) {
            urlString = mapdustUri;
            urlString = urlString + "/changeBugStatus";
            requestParameters.put("key", mapdustApiKey);
            requestParameters.put("id", comment.getBugId().toString());
            requestParameters.put("status", statusId.toString());
            requestParameters.put("comment", comment.getCommentText());
            requestParameters.put("nickname", comment.getNickname());
        }
        URL url = null;
        if (urlString != null) {
            url = new URL(urlString);
            httpResponse = this.getHttpConnector().executePOST(url, null, requestParameters);
        }
        return httpResponse;
    }

    private String buildParameter(List<? extends Object> list) {
        StringBuffer sb = new StringBuffer();
        for (Object object : list) {
            if (object == null) continue;
            sb.append(object).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private void handleStatusCode(HttpResponse httpResponse) throws MapdustConnectorException {
        String errorMessage = "";
        Integer statusCode = httpResponse.getStatusCode();
        String statusMessage = httpResponse.getStatusMessage();
        if (statusCode.equals(MapdustResponseStatusCode.Status200.getStatusCode()) || statusCode.equals(MapdustResponseStatusCode.Status201.getStatusCode()) || statusCode.equals(MapdustResponseStatusCode.Status204.getStatusCode())) {
            return;
        }
        switch (statusCode) {
            case 400: {
                errorMessage = statusMessage + " ";
                errorMessage = errorMessage + MapdustResponseStatusCode.Status400.getDescription();
                throw new MapdustConnectorException(errorMessage);
            }
            case 401: {
                errorMessage = statusMessage + " ";
                errorMessage = errorMessage + MapdustResponseStatusCode.Status401.getDescription();
                throw new MapdustConnectorException(errorMessage);
            }
            case 403: {
                errorMessage = statusMessage + " ";
                errorMessage = errorMessage + MapdustResponseStatusCode.Status403.getDescription();
                throw new MapdustConnectorException(errorMessage);
            }
            case 404: {
                errorMessage = statusMessage + " ";
                errorMessage = errorMessage + MapdustResponseStatusCode.Status404.getDescription();
                throw new MapdustConnectorException(errorMessage);
            }
            case 405: {
                errorMessage = statusMessage + " ";
                errorMessage = errorMessage + MapdustResponseStatusCode.Status405.getDescription();
                throw new MapdustConnectorException(errorMessage);
            }
            case 500: {
                errorMessage = statusMessage + " ";
                errorMessage = errorMessage + MapdustResponseStatusCode.Status500.getDescription();
                throw new MapdustConnectorException(errorMessage);
            }
            case 601: {
                errorMessage = statusMessage + " ";
                errorMessage = errorMessage + MapdustResponseStatusCode.Status601.getDescription();
                throw new MapdustConnectorException(errorMessage);
            }
            case 602: {
                errorMessage = statusMessage + " ";
                errorMessage = errorMessage + MapdustResponseStatusCode.Status602.getDescription();
                throw new MapdustConnectorException(errorMessage);
            }
        }
        throw new MapdustConnectorException(MapdustResponseStatusCode.Status.getDescription());
    }

    public HttpConnector getHttpConnector() {
        return this.httpConnector;
    }

    public MapdustParser getParser() {
        return this.parser;
    }
}

