/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.dialog;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.action.adapter.WindowClose;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteAddBug;
import org.openstreetmap.josm.plugins.mapdust.gui.action.execute.ExecuteCancel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.AbstractDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.renderer.ComboBoxRenderer;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.tools.ImageProvider;

public class CreateIssueDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1912577313684808253L;
    private String createIssueText = this.createIssueText + " description for the bug.";
    private JScrollPane cmpMessage;
    private JLabel lblType;
    private JComboBox cbbType;
    private JLabel lblNickname;
    private JTextField txtNickname;
    private JLabel lblDescription;
    private JScrollPane cmpDescription;
    private JTextArea txtDescription;
    private JButton btnCancel;
    private JButton btnOk;
    private final Point point;

    public CreateIssueDialog(Point point, MapdustPlugin mapdustPlugin) {
        this.point = point;
        this.initializeDialog();
        this.addComponents(mapdustPlugin);
        MapdustButtonPanel btnPanel = mapdustPlugin.getMapdustGUI().getPanel().getBtnPanel();
        this.addWindowListener(new WindowClose(this, btnPanel));
    }

    private void initializeDialog() {
        this.setTitle("Create bug report");
        this.setModal(true);
        Image image = ImageProvider.get((String)"dialogs/open.png").getImage();
        this.setIconImage(image);
        this.setDefaultCloseOperation(1);
        this.getContentPane().setFont(new Font("Times New Roman", 1, 14));
        this.setResizable(false);
        this.setForeground(Color.black);
        this.setLayout(null);
    }

    public void showDialog() {
        this.setLocationRelativeTo(null);
        this.getContentPane().setPreferredSize(this.getSize());
        this.pack();
        this.setVisible(true);
    }

    public void addComponents(MapdustPlugin mapdustPlugin) {
        Rectangle bounds;
        Rectangle bounds2;
        Color backgroundColor = this.getContentPane().getBackground();
        Font font = new Font("Times New Roman", 1, 14);
        if (this.cmpMessage == null) {
            JTextPane txtPane = ComponentUtil.createJTextPane(this.createIssueText, backgroundColor);
            bounds2 = new Rectangle(10, 10, 330, 50);
            this.cmpMessage = ComponentUtil.createJScrollPane(txtPane, bounds2, backgroundColor, true, true);
        }
        if (this.lblType == null) {
            bounds = new Rectangle(10, 70, 91, 25);
            this.lblType = ComponentUtil.createJLabel("Type", font, bounds);
        }
        if (this.cbbType == null) {
            ComboBoxRenderer renderer = new ComboBoxRenderer();
            bounds2 = new Rectangle(110, 70, 230, 25);
            this.cbbType = ComponentUtil.createJComboBox(bounds2, renderer, backgroundColor);
        }
        if (this.lblNickname == null) {
            bounds = new Rectangle(10, 110, 79, 25);
            this.lblNickname = ComponentUtil.createJLabel("Nickname", font, bounds);
        }
        if (this.txtNickname == null) {
            bounds = new Rectangle(110, 110, 230, 25);
            this.txtNickname = ComponentUtil.createJTextField(bounds);
            String nickname = Main.pref.get("mapdust.nickname");
            if (nickname.isEmpty()) {
                nickname = Main.pref.get("mapdust.josmUserName");
            }
            if (nickname != null && !nickname.isEmpty()) {
                this.txtNickname.setText(nickname);
            }
        }
        if (this.lblDescription == null) {
            bounds = new Rectangle(10, 150, 95, 25);
            this.lblDescription = ComponentUtil.createJLabel("Description", font, bounds);
        }
        if (this.cmpDescription == null) {
            bounds = new Rectangle(110, 150, 230, 50);
            this.txtDescription = new JTextArea();
            this.txtDescription.setFont(new Font("Times New Roman", 0, 12));
            this.txtDescription.setLineWrap(true);
            this.cmpDescription = ComponentUtil.createJScrollPane(this.txtDescription, bounds, backgroundColor, false, true);
        }
        if (this.btnCancel == null) {
            bounds = new Rectangle(250, 210, 90, 25);
            ExecuteCancel cancelAction = new ExecuteCancel(this, mapdustPlugin.getMapdustGUI());
            this.btnCancel = ComponentUtil.createJButton("Cancel", bounds, cancelAction);
        }
        if (this.btnOk == null) {
            bounds = new Rectangle(180, 210, 60, 25);
            ExecuteAddBug okAction = new ExecuteAddBug(this, mapdustPlugin.getMapdustGUI());
            okAction.addObserver(mapdustPlugin);
            okAction.addObserver(mapdustPlugin.getMapdustGUI());
            this.btnOk = ComponentUtil.createJButton("OK", bounds, okAction);
        }
        this.add(this.cmpMessage);
        this.add(this.lblType);
        this.add(this.cbbType);
        this.add(this.lblNickname);
        this.add(this.txtNickname);
        this.add(this.lblDescription);
        this.add(this.cmpDescription);
        this.add(this.btnCancel);
        this.add(this.btnOk);
        this.setSize(350, 250);
    }

    public JScrollPane getCmpMessage() {
        return this.cmpMessage;
    }

    public JLabel getLblType() {
        return this.lblType;
    }

    public JComboBox getCbbType() {
        return this.cbbType;
    }

    public JLabel getLblNickname() {
        return this.lblNickname;
    }

    public JTextField getTxtNickname() {
        return this.txtNickname;
    }

    public JLabel getLblDescription() {
        return this.lblDescription;
    }

    public JScrollPane getCmpDescription() {
        return this.cmpDescription;
    }

    public JTextArea getTxtDescription() {
        return this.txtDescription;
    }

    public Point getPoint() {
        return this.point;
    }
}

