/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.execute;

import javax.swing.AbstractAction;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.plugins.mapdust.gui.MapdustGUI;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.AbstractDialog;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;

public abstract class MapdustExecuteAction
extends AbstractAction {
    private static final long serialVersionUID = 4318259806647818543L;
    protected AbstractDialog dialog;
    protected MapdustGUI mapdustGUI;

    protected String validate(String nickname, String commentText) {
        String errorMessage = null;
        String invalidNickname = " Your nickname length has to be between 3";
        invalidNickname = invalidNickname + " and 16 characters.Please use letters,numbers, ";
        invalidNickname = invalidNickname + " '-', '.' or '_' '.'";
        if (this.emptyValue(nickname) && this.emptyValue(commentText)) {
            errorMessage = " Missing nickname and comment.";
            errorMessage = errorMessage + invalidNickname;
        } else if (this.emptyValue(nickname)) {
            errorMessage = " Missing nickname.";
            errorMessage = errorMessage + nickname;
        } else if (this.emptyValue(commentText)) {
            if (!this.validNickname(nickname)) {
                errorMessage = " Missing comment and invalid nickname.";
                errorMessage = errorMessage + invalidNickname;
            } else {
                errorMessage = " The comment is missing.";
            }
        } else if (!this.validNickname(nickname)) {
            errorMessage = " Invalid nickname.";
            errorMessage = errorMessage + invalidNickname;
        }
        return errorMessage;
    }

    protected String getIconPath(MapdustBug bug) {
        String iconPath = "bugs/normal/";
        iconPath = iconPath + bug.getStatus().getValue().toLowerCase();
        iconPath = iconPath + "_";
        iconPath = iconPath + bug.getType().getKey();
        iconPath = iconPath + ".png";
        return iconPath;
    }

    protected void enableFiredButton(JToggleButton button) {
        if (button != null) {
            button.setSelected(false);
            button.setFocusable(false);
        }
    }

    private boolean emptyValue(String value) {
        String modifiedValue;
        String string = modifiedValue = value != null ? value.trim() : "";
        return value == null || value.isEmpty() || modifiedValue.isEmpty();
    }

    private boolean validNickname(String value) {
        int length = value.length();
        return length >= 3 && length <= 16;
    }

    public AbstractDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(AbstractDialog dialog) {
        this.dialog = dialog;
    }

    public MapdustGUI getMapdustGUI() {
        return this.mapdustGUI;
    }

    public void setMapdustGUI(MapdustGUI mapdustGUI) {
        this.mapdustGUI = mapdustGUI;
    }
}

