/*
 * Decompiled with CFR 0.152.
 */
package toms.seamarks.buoys;

import java.util.Map;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import toms.Messages;
import toms.dialogs.SmpDialogAction;
import toms.seamarks.buoys.Buoy;

public class BuoyNota
extends Buoy {
    public BuoyNota(SmpDialogAction dia, Node node) {
        super(dia);
        Map keys = node.getKeys();
        this.setNode(node);
        this.resetMask();
        this.dlg.cbM01TypeOfMark.setSelectedIndex(6);
        this.dlg.cbM01CatOfMark.setEnabled(true);
        this.dlg.cbM01CatOfMark.setVisible(true);
        this.dlg.lM01CatOfMark.setVisible(true);
        this.dlg.cbM01CatOfMark.removeAllItems();
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.157"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.206"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.207"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.208"));
        this.dlg.cbM01CatOfMark.addItem(Messages.getString("SmpDialogAction.209"));
        this.setRegion(Main.pref.get("tomsplugin.IALA").equals("B"));
        if (keys.containsKey("name")) {
            this.setName((String)keys.get("name"));
        }
        if (keys.containsKey("seamark:name")) {
            this.setName((String)keys.get("seamark:name"));
        }
        if (keys.containsKey("seamark:longname")) {
            this.setLongname((String)keys.get("seamark:longname"));
        }
        if (keys.containsKey("seamark:fixme")) {
            this.setFixme((String)keys.get("seamark:fixme"));
        }
        if (keys.containsKey("seamark:landmark:height")) {
            this.setLMheight((String)keys.get("seamark:landmark:height"));
        }
        if (keys.containsKey("seamark:landmark:name")) {
            this.setName((String)keys.get("seamark:landmark:name"));
        } else if (keys.containsKey("seamark:light_major:name")) {
            this.setName((String)keys.get("seamark:light_major:name"));
        } else if (keys.containsKey("seamark:light_minor:name")) {
            this.setName((String)keys.get("seamark:light_minor:name"));
        } else if (keys.containsKey("seamark:light_vessel:name")) {
            this.setName((String)keys.get("seamark:light_vessel:name"));
        }
        if (keys.containsKey("seamark:type")) {
            String type = (String)keys.get("seamark:type");
            if (type.equals("landmark")) {
                this.setBuoyIndex(1);
            } else if (type.equals("light_major")) {
                this.setBuoyIndex(2);
            } else if (type.equals("light_minor")) {
                this.setBuoyIndex(3);
            } else if (type.equals("light_vessel")) {
                this.setBuoyIndex(4);
            }
        }
        this.refreshLights();
        this.parseLights(keys);
        this.parseFogRadar(keys);
        this.setTopMark(false);
        this.setFired(true);
        this.dlg.cbM01CatOfMark.setSelectedIndex(this.getBuoyIndex());
        this.dlg.tfM01Name.setText(this.getName());
        this.dlg.cM01Fired.setEnabled(false);
        this.dlg.cM01Fired.setSelected(true);
    }

    public boolean isValid() {
        return this.getBuoyIndex() > 0;
    }

    public void paintSign() {
        if (this.dlg.paintlock) {
            return;
        }
        super.paintSign();
        this.dlg.sM01StatusBar.setText(this.getErrMsg());
        if (this.isValid()) {
            this.dlg.cM01Radar.setVisible(true);
            this.dlg.cM01Racon.setVisible(true);
            this.dlg.cM01Fog.setVisible(true);
            this.dlg.rbM01Fired1.setVisible(true);
            this.dlg.rbM01FiredN.setVisible(true);
            this.dlg.lM01Height.setVisible(true);
            this.dlg.tfM01Height.setVisible(true);
            this.dlg.lM01Range.setVisible(true);
            this.dlg.tfM01Range.setVisible(true);
            switch (this.getBuoyIndex()) {
                case 1: {
                    this.dlg.lM01Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_House.png")));
                    break;
                }
                case 2: {
                    this.dlg.lM01Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Major.png")));
                    break;
                }
                case 3: {
                    this.dlg.lM01Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Light_Minor.png")));
                    break;
                }
                case 4: {
                    this.dlg.lM01Icon.setIcon(new ImageIcon(this.getClass().getResource("/images/Major_Float.png")));
                    break;
                }
            }
        }
    }

    public void saveSign() {
        Node node = this.getNode();
        if (node == null) {
            return;
        }
        switch (this.getBuoyIndex()) {
            case 1: {
                super.saveSign("landmark");
                break;
            }
            case 2: {
                super.saveSign("light_major");
                break;
            }
            case 3: {
                super.saveSign("light_minor");
                break;
            }
            case 4: {
                super.saveSign("light_vessel");
                break;
            }
        }
        if (!this.getLMheight().isEmpty()) {
            Main.main.undoRedo.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "seamark:landmark:height", this.getLMheight()));
        }
        this.saveLightData();
        this.saveRadarFogData();
    }

    public void setLightColour() {
    }
}

