/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.MolleweideProjection;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.proj.SinusoidalProjection;

public class GoodeProjection
extends Projection {
    private static final double Y_COR = 0.0528;
    private static final double PHI_LIM = 0.7109307819790236;
    private SinusoidalProjection sinu = new SinusoidalProjection();
    private MolleweideProjection moll = new MolleweideProjection();

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (Math.abs(d2) <= 0.7109307819790236) {
            projCoordinate = this.sinu.project(d, d2, projCoordinate);
        } else {
            projCoordinate = this.moll.project(d, d2, projCoordinate);
            projCoordinate.y = projCoordinate.y - (d2 >= 0.0 ? 0.0528 : -0.0528);
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate = Math.abs(d2) <= 0.7109307819790236 ? this.sinu.projectInverse(d, d2, projCoordinate) : this.moll.projectInverse(d, d2 += d2 >= 0.0 ? 0.0528 : -0.0528, projCoordinate);
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Goode Homolosine";
    }
}

