/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.AzimuthalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class EquidistantAzimuthalProjection
extends AzimuthalProjection {
    private static final double TOL = 1.0E-8;
    private int mode;
    private double[] en;
    private double M1;
    private double N1;
    private double Mp;
    private double He;
    private double G;
    private double sinphi0;
    private double cosphi0;

    public EquidistantAzimuthalProjection() {
        this(Math.toRadians(90.0), Math.toRadians(0.0));
    }

    public EquidistantAzimuthalProjection(double d, double d2) {
        super(d, d2);
        this.initialize();
    }

    @Override
    public Object clone() {
        EquidistantAzimuthalProjection equidistantAzimuthalProjection = (EquidistantAzimuthalProjection)super.clone();
        if (this.en != null) {
            equidistantAzimuthalProjection.en = (double[])this.en.clone();
        }
        return equidistantAzimuthalProjection;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10) {
            this.mode = this.projectionLatitude < 0.0 ? 2 : 1;
            this.sinphi0 = this.projectionLatitude < 0.0 ? -1.0 : 1.0;
            this.cosphi0 = 0.0;
        } else if (Math.abs(this.projectionLatitude) < 1.0E-10) {
            this.mode = 3;
            this.sinphi0 = 0.0;
            this.cosphi0 = 1.0;
        } else {
            this.mode = 4;
            this.sinphi0 = Math.sin(this.projectionLatitude);
            this.cosphi0 = Math.cos(this.projectionLatitude);
        }
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            switch (this.mode) {
                case 1: {
                    this.Mp = ProjectionMath.mlfn(1.5707963267948966, 1.0, 0.0, this.en);
                    break;
                }
                case 2: {
                    this.Mp = ProjectionMath.mlfn(-1.5707963267948966, -1.0, 0.0, this.en);
                    break;
                }
                case 3: 
                case 4: {
                    this.N1 = 1.0 / Math.sqrt(1.0 - this.es * this.sinphi0 * this.sinphi0);
                    this.He = this.e / Math.sqrt(this.one_es);
                    this.G = this.sinphi0 * this.He;
                    this.He *= this.cosphi0;
                }
            }
        }
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            double d5 = Math.cos(d);
            switch (this.mode) {
                case 3: 
                case 4: {
                    projCoordinate.y = this.mode == 3 ? d4 * d5 : this.sinphi0 * d3 + this.cosphi0 * d4 * d5;
                    if (Math.abs(Math.abs(projCoordinate.y) - 1.0) < 1.0E-8) {
                        if (projCoordinate.y < 0.0) {
                            throw new ProjectionException();
                        }
                        projCoordinate.y = 0.0;
                        projCoordinate.x = 0.0;
                        break;
                    }
                    projCoordinate.y = Math.acos(projCoordinate.y);
                    projCoordinate.y /= Math.sin(projCoordinate.y);
                    projCoordinate.x = projCoordinate.y * d4 * Math.sin(d);
                    projCoordinate.y = projCoordinate.y * (this.mode == 3 ? d3 : this.cosphi0 * d3 - this.sinphi0 * d4 * d5);
                    break;
                }
                case 1: {
                    d2 = -d2;
                    d5 = -d5;
                }
                case 2: {
                    if (Math.abs(d2 - 1.5707963267948966) < 1.0E-10) {
                        throw new ProjectionException();
                    }
                    projCoordinate.y = 1.5707963267948966 + d2;
                    projCoordinate.x = projCoordinate.y * Math.sin(d);
                    projCoordinate.y *= d5;
                }
            }
        } else {
            double d6 = Math.cos(d);
            double d7 = Math.cos(d2);
            double d8 = Math.sin(d2);
            switch (this.mode) {
                case 1: {
                    d6 = -d6;
                }
                case 2: {
                    double d9 = Math.abs(this.Mp - ProjectionMath.mlfn(d2, d8, d7, this.en));
                    projCoordinate.x = d9 * Math.sin(d);
                    projCoordinate.y = d9 * d6;
                    break;
                }
                case 3: 
                case 4: {
                    if (Math.abs(d) < 1.0E-10 && Math.abs(d2 - this.projectionLatitude) < 1.0E-10) {
                        projCoordinate.y = 0.0;
                        projCoordinate.x = 0.0;
                        break;
                    }
                    double d10 = Math.atan2(this.one_es * d8 + this.es * this.N1 * this.sinphi0 * Math.sqrt(1.0 - this.es * d8 * d8), d7);
                    double d11 = Math.cos(d10);
                    double d12 = Math.sin(d10);
                    double d13 = Math.atan2(Math.sin(d) * d11, this.cosphi0 * d12 - this.sinphi0 * d6 * d11);
                    double d14 = Math.cos(d13);
                    double d15 = Math.sin(d13);
                    double d16 = ProjectionMath.asin(Math.abs(d15) < 1.0E-8 ? (this.cosphi0 * d12 - this.sinphi0 * d6 * d11) / d14 : Math.sin(d) * d11 / d15);
                    double d17 = this.He * d14;
                    double d18 = d17 * d17;
                    double d19 = this.N1 * d16 * (1.0 + d16 * d16 * (-d18 * (1.0 - d18) / 6.0 + d16 * (this.G * d17 * (1.0 - 2.0 * d18 * d18) / 8.0 + d16 * ((d18 * (4.0 - 7.0 * d18) - 3.0 * this.G * this.G * (1.0 - 7.0 * d18)) / 120.0 - d16 * this.G * d17 / 48.0))));
                    projCoordinate.x = d19 * d15;
                    projCoordinate.y = d19 * d14;
                }
            }
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3;
            double d4 = ProjectionMath.distance(d, d2);
            if (d3 > Math.PI) {
                if (d4 - 1.0E-10 > Math.PI) {
                    throw new ProjectionException();
                }
                d4 = Math.PI;
            } else if (d4 < 1.0E-10) {
                projCoordinate.y = this.projectionLatitude;
                projCoordinate.x = 0.0;
                return projCoordinate;
            }
            if (this.mode == 4 || this.mode == 3) {
                double d5 = Math.sin(d4);
                double d6 = Math.cos(d4);
                if (this.mode == 3) {
                    projCoordinate.y = ProjectionMath.asin(d2 * d5 / d4);
                    d *= d5;
                    d2 = d6 * d4;
                } else {
                    projCoordinate.y = ProjectionMath.asin(d6 * this.sinphi0 + d2 * d5 * this.cosphi0 / d4);
                    d2 = (d6 - this.sinphi0 * Math.sin(projCoordinate.y)) * d4;
                    d *= d5 * this.cosphi0;
                }
                projCoordinate.x = d2 == 0.0 ? 0.0 : Math.atan2(d, d2);
            } else if (this.mode == 1) {
                projCoordinate.y = 1.5707963267948966 - d4;
                projCoordinate.x = Math.atan2(d, -d2);
            } else {
                projCoordinate.y = d4 - 1.5707963267948966;
                projCoordinate.x = Math.atan2(d, d2);
            }
        } else {
            double d7;
            double d8 = ProjectionMath.distance(d, d2);
            if (d7 < 1.0E-10) {
                projCoordinate.y = this.projectionLatitude;
                projCoordinate.x = 0.0;
                return projCoordinate;
            }
            if (this.mode == 4 || this.mode == 3) {
                double d9;
                double d10 = Math.atan2(d, d2);
                double d11 = Math.cos(d10);
                double d12 = this.cosphi0 * d11;
                double d13 = this.es * d12 / this.one_es;
                double d14 = -d13 * d12;
                double d15 = d8 / this.N1;
                double d16 = d15 * (1.0 - d15 * d15 * (d14 * (1.0 + d14) / 6.0 + (d13 *= 3.0 * (1.0 - d14) * this.sinphi0) * (1.0 + 3.0 * d14) * d15 / 24.0));
                double d17 = 1.0 - d16 * d16 * (d14 / 2.0 + d13 * d16 / 6.0);
                double d18 = ProjectionMath.asin(this.sinphi0 * Math.cos(d16) + d12 * Math.sin(d16));
                projCoordinate.x = ProjectionMath.asin(Math.sin(d10) * Math.sin(d16) / Math.cos(d18));
                d12 = Math.abs(d18);
                projCoordinate.y = d9 < 1.0E-10 ? 0.0 : (Math.abs(d12 - 1.5707963267948966) < 0.0 ? 1.5707963267948966 : Math.atan((1.0 - this.es * d17 * this.sinphi0 / Math.sin(d18)) * Math.tan(d18) / this.one_es));
            } else {
                projCoordinate.y = ProjectionMath.inv_mlfn(this.mode == 1 ? this.Mp - d8 : this.Mp + d8, this.es, this.en);
                projCoordinate.x = Math.atan2(d, this.mode == 1 ? -d2 : d2);
            }
        }
        return projCoordinate;
    }

    public Shape getBoundingShape() {
        double d = 1.5707963267948966 * this.a;
        return new Ellipse2D.Double(-d, -d, 2.0 * d, 2.0 * d);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Equidistant Azimuthal";
    }
}

