/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class AiryProjection
extends Projection {
    private double p_halfpi;
    private double sinph0;
    private double cosph0;
    private double Cb;
    private int mode;
    private boolean no_cut = true;
    private static final double EPS = 1.0E-10;
    private static final int N_POLE = 0;
    private static final int S_POLE = 1;
    private static final int EQUIT = 2;
    private static final int OBLIQ = 3;

    public AiryProjection() {
        this.minLatitude = Math.toRadians(-60.0);
        this.maxLatitude = Math.toRadians(60.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        switch (this.mode) {
            case 2: 
            case 3: {
                double d5;
                double d6 = Math.sin(d2);
                double d7 = Math.cos(d2);
                double d8 = d7 * d4;
                if (this.mode == 3) {
                    d8 = this.sinph0 * d6 + this.cosph0 * d8;
                }
                if (!this.no_cut && d8 < -1.0E-10) {
                    throw new ProjectionException("F");
                }
                double d9 = 1.0 - d8;
                if (Math.abs(d9) > 1.0E-10) {
                    double d10 = 0.5 * (1.0 + d8);
                    d5 = -Math.log(d10) / d9 - this.Cb / d10;
                } else {
                    d5 = 0.5 - this.Cb;
                }
                projCoordinate.x = d5 * d7 * d3;
                if (this.mode == 3) {
                    projCoordinate.y = d5 * (this.cosph0 * d6 - this.sinph0 * d7 * d4);
                    break;
                }
                projCoordinate.y = d5 * d6;
                break;
            }
            case 0: 
            case 1: {
                double d11;
                projCoordinate.y = Math.abs(this.p_halfpi - d2);
                if (!this.no_cut && d2 - 1.0E-10 > 1.5707963267948966) {
                    throw new ProjectionException("F");
                }
                projCoordinate.y *= 0.5;
                if (d11 > 1.0E-10) {
                    double d12 = Math.tan(d2);
                    double d13 = -2.0 * (Math.log(Math.cos(d2)) / d12 + d12 * this.Cb);
                    projCoordinate.x = d13 * d3;
                    projCoordinate.y = d13 * d4;
                    if (this.mode != 0) break;
                    projCoordinate.y = -projCoordinate.y;
                    break;
                }
                projCoordinate.y = 0.0;
                projCoordinate.x = 0.0;
            }
        }
        return projCoordinate;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.no_cut = false;
        double d = 0.7853981633974483;
        if (Math.abs(d) < 1.0E-10) {
            this.Cb = -0.5;
        } else {
            this.Cb = 1.0 / Math.tan(d);
            this.Cb *= this.Cb * Math.log(Math.cos(d));
        }
        if (Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10) {
            if (this.projectionLatitude < 0.0) {
                this.p_halfpi = -1.5707963267948966;
                this.mode = 1;
            } else {
                this.p_halfpi = 1.5707963267948966;
                this.mode = 0;
            }
        } else if (Math.abs(this.projectionLatitude) < 1.0E-10) {
            this.mode = 2;
        } else {
            this.mode = 3;
            this.sinph0 = Math.sin(this.projectionLatitude);
            this.cosph0 = Math.cos(this.projectionLatitude);
        }
    }

    @Override
    public String toString() {
        return "Airy";
    }
}

