/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class PutninsP2Projection
extends Projection {
    private static final double C_x = 1.8949;
    private static final double C_y = 1.71848;
    private static final double C_p = 0.6141848493043784;
    private static final double EPS = 1.0E-10;
    private static final int NITER = 10;
    private static final double PI_DIV_3 = 1.0471975511965976;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        double d3 = 0.6141848493043784 * Math.sin(d2);
        double d4 = d2 * d2;
        projCoordinate.y *= 0.615709 + d4 * (0.00909953 + d4 * 0.0046292);
        for (n = 10; n > 0; --n) {
            double d5 = Math.cos(d2);
            d4 = Math.sin(d2);
            double d6 = (d2 + d4 * (d5 - 1.0) - d3) / (1.0 + d5 * (d5 - 1.0) - d4 * d4);
            projCoordinate.y -= d6;
            if (Math.abs(d6) < 1.0E-10) break;
        }
        if (n == 0) {
            projCoordinate.y = d2 < 0.0 ? -1.0471975511965976 : 1.0471975511965976;
        }
        projCoordinate.x = 1.8949 * d * (Math.cos(d2) - 0.5);
        projCoordinate.y = 1.71848 * Math.sin(d2);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = ProjectionMath.asin(d2 / 1.71848);
        double d3 = Math.cos(projCoordinate.y);
        projCoordinate.x = d / (1.8949 * (d3 - 0.5));
        projCoordinate.y = ProjectionMath.asin((projCoordinate.y + Math.sin(projCoordinate.y) * (d3 - 1.0)) / 0.6141848493043784);
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Putnins P2";
    }
}

