/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.AzimuthalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class GnomonicAzimuthalProjection
extends AzimuthalProjection {
    public GnomonicAzimuthalProjection() {
        this(Math.toRadians(90.0), Math.toRadians(0.0));
    }

    public GnomonicAzimuthalProjection(double d, double d2) {
        super(d, d2);
        this.minLatitude = Math.toRadians(0.0);
        this.maxLatitude = Math.toRadians(90.0);
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = Math.cos(d);
        switch (this.mode) {
            case 3: {
                projCoordinate.y = d4 * d5;
                break;
            }
            case 4: {
                projCoordinate.y = this.sinphi0 * d3 + this.cosphi0 * d4 * d5;
                break;
            }
            case 2: {
                projCoordinate.y = -d3;
                break;
            }
            case 1: {
                projCoordinate.y = d3;
            }
        }
        if (Math.abs(projCoordinate.y) <= 1.0E-10) {
            throw new ProjectionException();
        }
        projCoordinate.y = 1.0 / projCoordinate.y;
        projCoordinate.x = projCoordinate.y * d4 * Math.sin(d);
        switch (this.mode) {
            case 3: {
                projCoordinate.y *= d3;
                break;
            }
            case 4: {
                projCoordinate.y *= this.cosphi0 * d3 - this.sinphi0 * d4 * d5;
                break;
            }
            case 1: {
                d5 = -d5;
            }
            case 2: {
                projCoordinate.y *= d4 * d5;
            }
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = ProjectionMath.distance(d, d2);
        projCoordinate.y = Math.atan(d3);
        double d4 = Math.sin(projCoordinate.y);
        double d5 = Math.sqrt(1.0 - d4 * d4);
        if (Math.abs(d3) <= 1.0E-10) {
            projCoordinate.y = this.projectionLatitude;
            projCoordinate.x = 0.0;
        } else {
            switch (this.mode) {
                case 4: {
                    projCoordinate.y = d5 * this.sinphi0 + d2 * d4 * this.cosphi0 / d3;
                    projCoordinate.y = Math.abs(projCoordinate.y) >= 1.0 ? (projCoordinate.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.asin(projCoordinate.y);
                    d2 = (d5 - this.sinphi0 * Math.sin(projCoordinate.y)) * d3;
                    d *= d4 * this.cosphi0;
                    break;
                }
                case 3: {
                    projCoordinate.y = d2 * d4 / d3;
                    projCoordinate.y = Math.abs(projCoordinate.y) >= 1.0 ? (projCoordinate.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.asin(projCoordinate.y);
                    d2 = d5 * d3;
                    d *= d4;
                    break;
                }
                case 2: {
                    projCoordinate.y -= 1.5707963267948966;
                    break;
                }
                case 1: {
                    projCoordinate.y = 1.5707963267948966 - projCoordinate.y;
                    d2 = -d2;
                }
            }
            projCoordinate.x = Math.atan2(d, d2);
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Gnomonic Azimuthal";
    }
}

