/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j;

import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.Proj4jException;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.GeocentricConverter;

public class BasicCoordinateTransform
implements CoordinateTransform {
    private CoordinateReferenceSystem srcCRS;
    private CoordinateReferenceSystem tgtCRS;
    private ProjCoordinate geoCoord = new ProjCoordinate(0.0, 0.0);
    private boolean doInverseProjection = true;
    private boolean doForwardProjection = true;
    private boolean doDatumTransform = false;
    private boolean transformViaGeocentric = false;
    private GeocentricConverter srcGeoConv;
    private GeocentricConverter tgtGeoConv;

    public BasicCoordinateTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        this.srcCRS = coordinateReferenceSystem;
        this.tgtCRS = coordinateReferenceSystem2;
        this.doInverseProjection = coordinateReferenceSystem != null && coordinateReferenceSystem != CoordinateReferenceSystem.CS_GEO;
        this.doForwardProjection = coordinateReferenceSystem2 != null && coordinateReferenceSystem2 != CoordinateReferenceSystem.CS_GEO;
        boolean bl = this.doDatumTransform = this.doInverseProjection && this.doForwardProjection && coordinateReferenceSystem.getDatum() != coordinateReferenceSystem2.getDatum();
        if (this.doDatumTransform) {
            boolean bl2 = coordinateReferenceSystem.getDatum().getEllipsoid().isEqual(coordinateReferenceSystem2.getDatum().getEllipsoid());
            if (!bl2) {
                this.transformViaGeocentric = true;
            }
            if (coordinateReferenceSystem.getDatum().hasTransformToWGS84() || coordinateReferenceSystem2.getDatum().hasTransformToWGS84()) {
                this.transformViaGeocentric = true;
            }
            if (this.transformViaGeocentric) {
                this.srcGeoConv = new GeocentricConverter(coordinateReferenceSystem.getDatum().getEllipsoid());
                this.tgtGeoConv = new GeocentricConverter(coordinateReferenceSystem2.getDatum().getEllipsoid());
            }
        }
    }

    @Override
    public CoordinateReferenceSystem getSourceCRS() {
        return this.srcCRS;
    }

    @Override
    public CoordinateReferenceSystem getTargetCRS() {
        return this.tgtCRS;
    }

    @Override
    public ProjCoordinate transform(ProjCoordinate projCoordinate, ProjCoordinate projCoordinate2) throws Proj4jException {
        if (this.doInverseProjection) {
            this.srcCRS.getProjection().inverseProjectRadians(projCoordinate, this.geoCoord);
        } else {
            this.geoCoord.setValue(projCoordinate);
        }
        if (this.doDatumTransform) {
            this.datumTransform(this.geoCoord);
        }
        if (this.doForwardProjection) {
            this.tgtCRS.getProjection().projectRadians(this.geoCoord, projCoordinate2);
        } else {
            projCoordinate2.setValue(this.geoCoord);
        }
        return projCoordinate2;
    }

    private void datumTransform(ProjCoordinate projCoordinate) {
        if (this.srcCRS.getDatum().isEqual(this.tgtCRS.getDatum())) {
            return;
        }
        if (this.transformViaGeocentric) {
            this.srcGeoConv.convertGeodeticToGeocentric(projCoordinate);
            if (this.srcCRS.getDatum().hasTransformToWGS84()) {
                this.srcCRS.getDatum().transformFromGeocentricToWgs84(projCoordinate);
            }
            if (this.tgtCRS.getDatum().hasTransformToWGS84()) {
                this.tgtCRS.getDatum().transformToGeocentricFromWgs84(projCoordinate);
            }
            this.tgtGeoConv.convertGeocentricToGeodetic(projCoordinate);
        }
    }
}

