/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class URMFPSProjection
extends Projection {
    private static final double C_x = 0.8773826753;
    private static final double Cy = 1.139753528477;
    private double n = 0.8660254037844386;
    private double C_y;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = ProjectionMath.asin(this.n * Math.sin(d2));
        projCoordinate.x = 0.8773826753 * d * Math.cos(d2);
        projCoordinate.y = this.C_y * d2;
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = ProjectionMath.asin(Math.sin(d2 /= this.C_y) / this.n);
        projCoordinate.x = d / (0.8773826753 * Math.cos(d2));
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.n <= 0.0 || this.n > 1.0) {
            throw new ProjectionException("-40");
        }
        this.C_y = 1.139753528477 / this.n;
    }

    public void setN(double d) {
        this.n = d;
    }

    public double getN() {
        return this.n;
    }

    @Override
    public String toString() {
        return "Urmaev Flat-Polar Sinusoidal";
    }
}

