/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.datum.Ellipsoid;
import org.osgeo.proj4j.proj.ConicProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class LambertConformalConicProjection
extends ConicProjection {
    private double n;
    private double rho0;
    private double c;

    public LambertConformalConicProjection() {
        this.minLatitude = Math.toRadians(0.0);
        this.maxLatitude = Math.toRadians(80.0);
        this.projectionLatitude = 0.7853981633974483;
        this.projectionLatitude1 = 0.0;
        this.projectionLatitude2 = 0.0;
        this.initialize();
    }

    public LambertConformalConicProjection(Ellipsoid ellipsoid, double d, double d2, double d3, double d4, double d5, double d6) {
        this.setEllipsoid(ellipsoid);
        this.projectionLongitude = d;
        this.projectionLatitude = d4;
        this.scaleFactor = 1.0;
        this.falseEasting = d5;
        this.falseNorthing = d6;
        this.projectionLatitude1 = d2;
        this.projectionLatitude2 = d3;
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.abs(Math.abs(d2) - 1.5707963267948966) < 1.0E-10 ? 0.0 : this.c * (this.spherical ? Math.pow(Math.tan(0.7853981633974483 + 0.5 * d2), -this.n) : Math.pow(ProjectionMath.tsfn(d2, Math.sin(d2), this.e), this.n));
        projCoordinate.x = this.scaleFactor * (d3 * Math.sin(d *= this.n));
        projCoordinate.y = this.scaleFactor * (this.rho0 - d3 * Math.cos(d));
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        d2 /= this.scaleFactor;
        double d3 = ProjectionMath.distance(d /= this.scaleFactor, d2 = this.rho0 - d2);
        if (d3 != 0.0) {
            if (this.n < 0.0) {
                d3 = -d3;
                d = -d;
                d2 = -d2;
            }
            projCoordinate.y = this.spherical ? 2.0 * Math.atan(Math.pow(this.c / d3, 1.0 / this.n)) - 1.5707963267948966 : ProjectionMath.phi2(Math.pow(d3 / this.c, 1.0 / this.n), this.e);
            projCoordinate.x = Math.atan2(d, d2) / this.n;
        } else {
            projCoordinate.x = 0.0;
            projCoordinate.y = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return projCoordinate;
    }

    @Override
    public void initialize() {
        double d;
        super.initialize();
        if (this.projectionLatitude1 == 0.0) {
            this.projectionLatitude1 = this.projectionLatitude2 = this.projectionLatitude;
        }
        if (Math.abs(this.projectionLatitude1 + this.projectionLatitude2) < 1.0E-10) {
            throw new ProjectionException();
        }
        this.n = d = Math.sin(this.projectionLatitude1);
        double d2 = Math.cos(this.projectionLatitude1);
        boolean bl = Math.abs(this.projectionLatitude1 - this.projectionLatitude2) >= 1.0E-10;
        boolean bl2 = this.spherical = this.es == 0.0;
        if (!this.spherical) {
            double d3 = ProjectionMath.msfn(d, d2, this.es);
            double d4 = ProjectionMath.tsfn(this.projectionLatitude1, d, this.e);
            if (bl) {
                d = Math.sin(this.projectionLatitude2);
                this.n = Math.log(d3 / ProjectionMath.msfn(d, Math.cos(this.projectionLatitude2), this.es));
                this.n /= Math.log(d4 / ProjectionMath.tsfn(this.projectionLatitude2, d, this.e));
            }
            this.c = this.rho0 = d3 * Math.pow(d4, -this.n) / this.n;
            this.rho0 *= Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10 ? 0.0 : Math.pow(ProjectionMath.tsfn(this.projectionLatitude, Math.sin(this.projectionLatitude), this.e), this.n);
        } else {
            if (bl) {
                this.n = Math.log(d2 / Math.cos(this.projectionLatitude2)) / Math.log(Math.tan(0.7853981633974483 + 0.5 * this.projectionLatitude2) / Math.tan(0.7853981633974483 + 0.5 * this.projectionLatitude1));
            }
            this.c = d2 * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.projectionLatitude1), this.n) / this.n;
            this.rho0 = Math.abs(Math.abs(this.projectionLatitude) - 1.5707963267948966) < 1.0E-10 ? 0.0 : this.c * Math.pow(Math.tan(0.7853981633974483 + 0.5 * this.projectionLatitude), -this.n);
        }
    }

    @Override
    public boolean isConformal() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Lambert Conformal Conic";
    }
}

