/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class LagrangeProjection
extends Projection {
    private double hrw;
    private double rw = 1.4;
    private double a1;
    private double phi1;
    private static final double TOL = 1.0E-10;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (Math.abs(Math.abs(d2) - 1.5707963267948966) < 1.0E-10) {
            projCoordinate.x = 0.0;
            projCoordinate.y = d2 < 0.0 ? -2.0 : 2.0;
        } else {
            double d3;
            d2 = Math.sin(d2);
            double d4 = this.a1 * Math.pow((1.0 + d2) / (1.0 - d2), this.hrw);
            double d5 = 0.5 * (d4 + 1.0 / d4) + Math.cos(d *= this.rw);
            if (d3 < 1.0E-10) {
                throw new ProjectionException();
            }
            projCoordinate.x = 2.0 * Math.sin(d) / d5;
            projCoordinate.y = (d4 - 1.0 / d4) / d5;
        }
        return projCoordinate;
    }

    public void setW(double d) {
        this.rw = d;
    }

    public double getW() {
        return this.rw;
    }

    @Override
    public void initialize() {
        double d;
        super.initialize();
        if (this.rw <= 0.0) {
            throw new ProjectionException("-27");
        }
        this.rw = 1.0 / this.rw;
        this.hrw = 0.5 * this.rw;
        this.phi1 = this.projectionLatitude1;
        this.phi1 = Math.sin(this.phi1);
        if (Math.abs(Math.abs(d) - 1.0) < 1.0E-10) {
            throw new ProjectionException("-22");
        }
        this.a1 = Math.pow((1.0 - this.phi1) / (1.0 + this.phi1), this.hrw);
    }

    @Override
    public boolean isConformal() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return false;
    }

    @Override
    public String toString() {
        return "Lagrange";
    }
}

