/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.ConicProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class EquidistantConicProjection
extends ConicProjection {
    private double standardLatitude1;
    private double standardLatitude2;
    private double eccentricity = 0.822719;
    private double eccentricity2 = this.eccentricity * this.eccentricity;
    private double eccentricity4 = this.eccentricity2 * this.eccentricity2;
    private double eccentricity6 = this.eccentricity2 * this.eccentricity4;
    private double radius = 1.0;
    private boolean northPole;
    private double f;
    private double n;
    private double rho0;

    public EquidistantConicProjection() {
        this.minLatitude = ProjectionMath.degToRad(10.0);
        this.maxLatitude = ProjectionMath.degToRad(70.0);
        this.minLongitude = ProjectionMath.degToRad(-90.0);
        this.maxLongitude = ProjectionMath.degToRad(90.0);
        this.standardLatitude1 = Math.toDegrees(60.0);
        this.standardLatitude2 = Math.toDegrees(20.0);
        this.initialize(ProjectionMath.degToRad(0.0), ProjectionMath.degToRad(37.5), this.standardLatitude1, this.standardLatitude2);
    }

    @Override
    public ProjCoordinate project(ProjCoordinate projCoordinate, ProjCoordinate projCoordinate2) {
        double d = ProjectionMath.normalizeLongitude(projCoordinate.x - this.projectionLongitude);
        double d2 = projCoordinate.y;
        double d3 = Math.pow((1.0 - this.eccentricity * Math.sin(d2)) / (1.0 + this.eccentricity * Math.sin(d2)), 0.5 * this.eccentricity);
        double d4 = Math.tan(0.7853981633974483 - 0.5 * d2);
        double d5 = d4 == 0.0 ? 0.0 : Math.pow(d4 / d3, this.n);
        double d6 = this.radius * this.f * d5;
        double d7 = this.n * d;
        projCoordinate2.x = d6 * Math.sin(d7);
        projCoordinate2.y = this.rho0 - d6 * Math.cos(d7);
        return projCoordinate2;
    }

    @Override
    public ProjCoordinate inverseProject(ProjCoordinate projCoordinate, ProjCoordinate projCoordinate2) {
        double d = 0.0;
        double d2 = Math.atan(projCoordinate.x / (this.rho0 - projCoordinate.y));
        projCoordinate2.x = d2 / this.n + this.projectionLongitude;
        double d3 = projCoordinate.x * projCoordinate.x + (this.rho0 - projCoordinate.y) * (this.rho0 - projCoordinate.y);
        double d4 = Math.sqrt(d3);
        if (this.n < 0.0) {
            d4 = -d4;
        }
        double d5 = Math.pow(d4 / (this.radius * this.f), 1.0 / this.n);
        double d6 = 1.5707963267948966 - 2.0 * Math.atan(d5);
        double d7 = 1.0;
        for (int i = 0; i < 100 && d7 > 1.0E-8; ++i) {
            d3 = (1.0 - this.eccentricity * Math.sin(d6)) / (1.0 + this.eccentricity * Math.sin(d6));
            d = 1.5707963267948966 - 2.0 * Math.atan(d5 * Math.pow(d3, 0.5 * this.eccentricity));
            d7 = Math.abs(Math.abs(d6) - Math.abs(d));
            d6 = d;
        }
        projCoordinate2.y = d;
        return projCoordinate2;
    }

    private void initialize(double d, double d2, double d3, double d4) {
        super.initialize();
        this.northPole = d2 > 0.0;
        this.projectionLatitude = this.northPole ? 1.5707963267948966 : -1.5707963267948966;
        double d5 = Math.tan(0.7853981633974483 - 0.5 * d3) / Math.pow((1.0 - this.eccentricity * Math.sin(d3)) / (1.0 + this.eccentricity * Math.sin(d3)), 0.5 * this.eccentricity);
        double d6 = Math.cos(d3) / Math.sqrt(1.0 - this.eccentricity2 * Math.pow(Math.sin(d3), 2.0));
        double d7 = Math.tan(0.7853981633974483 - 0.5 * d4) / Math.pow((1.0 - this.eccentricity * Math.sin(d4)) / (1.0 + this.eccentricity * Math.sin(d4)), 0.5 * this.eccentricity);
        double d8 = Math.cos(d4) / Math.sqrt(1.0 - this.eccentricity2 * Math.pow(Math.sin(d4), 2.0));
        double d9 = Math.tan(0.7853981633974483 - 0.5 * d2) / Math.pow((1.0 - this.eccentricity * Math.sin(d2)) / (1.0 + this.eccentricity * Math.sin(d2)), 0.5 * this.eccentricity);
        this.n = d3 != d4 ? (Math.log(d6) - Math.log(d8)) / (Math.log(d5) - Math.log(d7)) : Math.sin(d3);
        this.f = d6 / (this.n * Math.pow(d5, this.n));
        this.projectionLongitude = d;
        this.rho0 = this.radius * this.f * Math.pow(d9, this.n);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Equidistant Conic";
    }
}

