/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.AzimuthalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class EqualAreaAzimuthalProjection
extends AzimuthalProjection {
    private double sinb1;
    private double cosb1;
    private double xmf;
    private double ymf;
    private double mmf;
    private double qp;
    private double dd;
    private double rq;
    private double[] apa;

    public EqualAreaAzimuthalProjection() {
        this.initialize();
    }

    @Override
    public Object clone() {
        EqualAreaAzimuthalProjection equalAreaAzimuthalProjection = (EqualAreaAzimuthalProjection)super.clone();
        if (this.apa != null) {
            equalAreaAzimuthalProjection.apa = (double[])this.apa.clone();
        }
        return equalAreaAzimuthalProjection;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.spherical) {
            if (this.mode == 4) {
                this.sinphi0 = Math.sin(this.projectionLatitude);
                this.cosphi0 = Math.cos(this.projectionLatitude);
            }
        } else {
            this.qp = ProjectionMath.qsfn(1.0, this.e, this.one_es);
            this.mmf = 0.5 / (1.0 - this.es);
            this.apa = ProjectionMath.authset(this.es);
            switch (this.mode) {
                case 1: 
                case 2: {
                    this.dd = 1.0;
                    break;
                }
                case 3: {
                    this.rq = Math.sqrt(0.5 * this.qp);
                    this.dd = 1.0 / this.rq;
                    this.xmf = 1.0;
                    this.ymf = 0.5 * this.qp;
                    break;
                }
                case 4: {
                    this.rq = Math.sqrt(0.5 * this.qp);
                    double d = Math.sin(this.projectionLatitude);
                    this.sinb1 = ProjectionMath.qsfn(d, this.e, this.one_es) / this.qp;
                    this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
                    this.dd = Math.cos(this.projectionLatitude) / (Math.sqrt(1.0 - this.es * d * d) * this.rq * this.cosb1);
                    this.xmf = this.rq;
                    this.ymf = this.xmf / this.dd;
                    this.xmf *= this.dd;
                }
            }
        }
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            double d5 = Math.cos(d);
            switch (this.mode) {
                case 3: {
                    projCoordinate.y = 1.0 + d4 * d5;
                    if (projCoordinate.y <= 1.0E-10) {
                        throw new ProjectionException();
                    }
                    projCoordinate.y = Math.sqrt(2.0 / projCoordinate.y);
                    projCoordinate.x = projCoordinate.y * d4 * Math.sin(d);
                    projCoordinate.y = projCoordinate.y * (this.mode == 3 ? d3 : this.cosphi0 * d3 - this.sinphi0 * d4 * d5);
                    break;
                }
                case 4: {
                    projCoordinate.y = 1.0 + this.sinphi0 * d3 + this.cosphi0 * d4 * d5;
                    if (projCoordinate.y <= 1.0E-10) {
                        throw new ProjectionException();
                    }
                    projCoordinate.y = Math.sqrt(2.0 / projCoordinate.y);
                    projCoordinate.x = projCoordinate.y * d4 * Math.sin(d);
                    projCoordinate.y = projCoordinate.y * (this.mode == 3 ? d3 : this.cosphi0 * d3 - this.sinphi0 * d4 * d5);
                    break;
                }
                case 1: {
                    d5 = -d5;
                }
                case 2: {
                    if (Math.abs(d2 + this.projectionLatitude) < 1.0E-10) {
                        throw new ProjectionException();
                    }
                    projCoordinate.y = 0.7853981633974483 - d2 * 0.5;
                    projCoordinate.y = 2.0 * (this.mode == 2 ? Math.cos(projCoordinate.y) : Math.sin(projCoordinate.y));
                    projCoordinate.x = projCoordinate.y * Math.sin(d);
                    projCoordinate.y *= d5;
                }
            }
        } else {
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = Math.cos(d);
            double d10 = Math.sin(d);
            double d11 = Math.sin(d2);
            double d12 = ProjectionMath.qsfn(d11, this.e, this.one_es);
            if (this.mode == 4 || this.mode == 3) {
                d6 = d12 / this.qp;
                d7 = Math.sqrt(1.0 - d6 * d6);
            }
            switch (this.mode) {
                case 4: {
                    d8 = 1.0 + this.sinb1 * d6 + this.cosb1 * d7 * d9;
                    break;
                }
                case 3: {
                    d8 = 1.0 + d7 * d9;
                    break;
                }
                case 1: {
                    d8 = 1.5707963267948966 + d2;
                    d12 = this.qp - d12;
                    break;
                }
                case 2: {
                    d8 = d2 - 1.5707963267948966;
                    d12 = this.qp + d12;
                }
            }
            if (Math.abs(d8) < 1.0E-10) {
                throw new ProjectionException();
            }
            switch (this.mode) {
                case 4: {
                    d8 = Math.sqrt(2.0 / d8);
                    projCoordinate.y = this.ymf * d8 * (this.cosb1 * d6 - this.sinb1 * d7 * d9);
                    projCoordinate.x = this.xmf * d8 * d7 * d10;
                    break;
                }
                case 3: {
                    d8 = Math.sqrt(2.0 / (1.0 + d7 * d9));
                    projCoordinate.y = d8 * d6 * this.ymf;
                    projCoordinate.x = this.xmf * d8 * d7 * d10;
                    break;
                }
                case 1: 
                case 2: {
                    if (d12 >= 0.0) {
                        d8 = Math.sqrt(d12);
                        projCoordinate.x = d8 * d10;
                        projCoordinate.y = d9 * (this.mode == 2 ? d8 : -d8);
                        break;
                    }
                    projCoordinate.y = 0.0;
                    projCoordinate.x = 0.0;
                }
            }
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = ProjectionMath.distance(d, d2);
            projCoordinate.y = d6 * 0.5;
            if (d3 > 1.0) {
                throw new ProjectionException();
            }
            projCoordinate.y = 2.0 * Math.asin(projCoordinate.y);
            if (this.mode == 4 || this.mode == 3) {
                d5 = Math.sin(projCoordinate.y);
                d4 = Math.cos(projCoordinate.y);
            }
            switch (this.mode) {
                case 3: {
                    projCoordinate.y = Math.abs(d6) <= 1.0E-10 ? 0.0 : Math.asin(d2 * d5 / d6);
                    d *= d5;
                    d2 = d4 * d6;
                    break;
                }
                case 4: {
                    projCoordinate.y = Math.abs(d6) <= 1.0E-10 ? this.projectionLatitude : Math.asin(d4 * this.sinphi0 + d2 * d5 * this.cosphi0 / d6);
                    d *= d5 * this.cosphi0;
                    d2 = (d4 - Math.sin(projCoordinate.y) * this.sinphi0) * d6;
                    break;
                }
                case 1: {
                    d2 = -d2;
                    projCoordinate.y = 1.5707963267948966 - projCoordinate.y;
                    break;
                }
                case 2: {
                    projCoordinate.y -= 1.5707963267948966;
                }
            }
            projCoordinate.x = d2 == 0.0 && (this.mode == 3 || this.mode == 4) ? 0.0 : Math.atan2(d, d2);
        } else {
            double d7 = 0.0;
            switch (this.mode) {
                case 3: 
                case 4: {
                    double d8;
                    double d9 = ProjectionMath.distance(d /= this.dd, d2 *= this.dd);
                    if (d8 < 1.0E-10) {
                        projCoordinate.x = 0.0;
                        projCoordinate.y = this.projectionLatitude;
                        return projCoordinate;
                    }
                    double d10 = 2.0 * Math.asin(0.5 * d9 / this.rq);
                    double d11 = Math.cos(d10);
                    d10 = Math.sin(d10);
                    d *= d10;
                    if (this.mode == 4) {
                        d7 = d11 * this.sinb1 + d2 * d10 * this.cosb1 / d9;
                        double d12 = this.qp * d7;
                        d2 = d9 * this.cosb1 * d11 - d2 * this.sinb1 * d10;
                        break;
                    }
                    d7 = d2 * d10 / d9;
                    double d13 = this.qp * d7;
                    d2 = d9 * d11;
                    break;
                }
                case 1: {
                    d2 = -d2;
                }
                case 2: {
                    double d14 = d * d + d2 * d2;
                    if (d14 == 0.0) {
                        projCoordinate.x = 0.0;
                        projCoordinate.y = this.projectionLatitude;
                        return projCoordinate;
                    }
                    d7 = 1.0 - d14 / this.qp;
                    if (this.mode != 2) break;
                    d7 = -d7;
                }
            }
            projCoordinate.x = Math.atan2(d, d2);
            projCoordinate.y = ProjectionMath.authlat(Math.asin(d7), this.apa);
        }
        return projCoordinate;
    }

    public Shape getBoundingShape() {
        double d = 1.414 * this.a;
        return new Ellipse2D.Double(-d, -d, 2.0 * d, 2.0 * d);
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Lambert Equal Area Azimuthal";
    }
}

