/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.io;

import java.io.PrintStream;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.CoordinateTransformFactory;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.util.CRSCache;
import org.osgeo.proj4j.util.ProjectionUtil;

public class MetaCRSTestCase {
    private static final CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
    private boolean verbose = true;
    String testName;
    String testMethod;
    String srcCrsAuth;
    String srcCrs;
    String tgtCrsAuth;
    String tgtCrs;
    double srcOrd1;
    double srcOrd2;
    double srcOrd3;
    double tgtOrd1;
    double tgtOrd2;
    double tgtOrd3;
    double tolOrd1;
    double tolOrd2;
    double tolOrd3;
    String using;
    String dataSource;
    String dataCmnts;
    String maintenanceCmnts;
    CoordinateReferenceSystem srcCS;
    CoordinateReferenceSystem tgtCS;
    ProjCoordinate srcPt = new ProjCoordinate();
    ProjCoordinate resultPt = new ProjCoordinate();
    private boolean isInTol;
    private CRSCache crsCache = null;

    public MetaCRSTestCase(String string, String string2, String string3, String string4, String string5, String string6, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, String string7, String string8, String string9, String string10) {
        this.testName = string;
        this.testMethod = string2;
        this.srcCrsAuth = string3;
        this.srcCrs = string4;
        this.tgtCrsAuth = string5;
        this.tgtCrs = string6;
        this.srcOrd1 = d;
        this.srcOrd2 = d2;
        this.srcOrd3 = d3;
        this.tgtOrd1 = d4;
        this.tgtOrd2 = d5;
        this.tgtOrd3 = d6;
        this.tolOrd1 = d7;
        this.tolOrd2 = d8;
        this.tolOrd3 = d9;
        this.using = string7;
        this.dataSource = string8;
        this.dataCmnts = string9;
        this.maintenanceCmnts = string10;
    }

    public String getName() {
        return this.testName;
    }

    public String getSourceCrsName() {
        return MetaCRSTestCase.csName(this.srcCrsAuth, this.srcCrs);
    }

    public String getTargetCrsName() {
        return MetaCRSTestCase.csName(this.tgtCrsAuth, this.tgtCrs);
    }

    public CoordinateReferenceSystem getSourceCS() {
        return this.srcCS;
    }

    public CoordinateReferenceSystem getTargetCS() {
        return this.tgtCS;
    }

    public ProjCoordinate getSourceCoordinate() {
        return new ProjCoordinate(this.srcOrd1, this.srcOrd2, this.srcOrd3);
    }

    public ProjCoordinate getTargetCoordinate() {
        return new ProjCoordinate(this.tgtOrd1, this.tgtOrd2, this.tgtOrd3);
    }

    public ProjCoordinate getResultCoordinate() {
        return new ProjCoordinate(this.resultPt.x, this.resultPt.y);
    }

    public void setCache(CRSCache cRSCache) {
        this.crsCache = cRSCache;
    }

    public boolean execute(CRSFactory cRSFactory) {
        boolean bl = false;
        this.srcCS = this.createCS(cRSFactory, this.srcCrsAuth, this.srcCrs);
        this.tgtCS = this.createCS(cRSFactory, this.tgtCrsAuth, this.tgtCrs);
        bl = this.executeTransform(this.srcCS, this.tgtCS);
        return bl;
    }

    public static String csName(String string, String string2) {
        return string + ":" + string2;
    }

    public CoordinateReferenceSystem createCS(CRSFactory cRSFactory, String string, String string2) {
        String string3 = MetaCRSTestCase.csName(string, string2);
        if (this.crsCache != null) {
            return this.crsCache.createFromName(string3);
        }
        CoordinateReferenceSystem coordinateReferenceSystem = cRSFactory.createFromName(string3);
        return coordinateReferenceSystem;
    }

    private boolean executeTransform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        this.srcPt.x = this.srcOrd1;
        this.srcPt.y = this.srcOrd2;
        CoordinateTransform coordinateTransform = ctFactory.createTransform(coordinateReferenceSystem, coordinateReferenceSystem2);
        coordinateTransform.transform(this.srcPt, this.resultPt);
        double d = Math.abs(this.resultPt.x - this.tgtOrd1);
        double d2 = Math.abs(this.resultPt.y - this.tgtOrd2);
        this.isInTol = d <= this.tolOrd1 && d2 <= this.tolOrd2;
        return this.isInTol;
    }

    public void print(PrintStream printStream) {
        System.out.println(this.testName);
        System.out.println(ProjectionUtil.toString(this.srcPt) + " -> " + ProjectionUtil.toString(this.resultPt) + " ( expected: " + this.tgtOrd1 + ", " + this.tgtOrd2 + " )");
        if (!this.isInTol) {
            System.out.println("FAIL");
            System.out.println("Src CRS: (" + this.srcCrsAuth + ":" + this.srcCrs + ") " + this.srcCS.getParameterString());
            System.out.println("Tgt CRS: (" + this.tgtCrsAuth + ":" + this.tgtCrs + ") " + this.tgtCS.getParameterString());
        }
    }
}

