/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ConvergenceFailureException;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.AzimuthalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class StereographicAzimuthalProjection
extends AzimuthalProjection {
    private static final double TOL = 1.0E-8;
    private double akm1;

    public StereographicAzimuthalProjection() {
        this(Math.toRadians(90.0), Math.toRadians(0.0));
    }

    public StereographicAzimuthalProjection(double d, double d2) {
        super(d, d2);
        this.initialize();
    }

    public void setupUPS(int n) {
        this.projectionLatitude = n == 2 ? -1.5707963267948966 : 1.5707963267948966;
        this.projectionLongitude = 0.0;
        this.scaleFactor = 0.994;
        this.falseEasting = 2000000.0;
        this.falseNorthing = 2000000.0;
        this.trueScaleLatitude = 1.5707963267948966;
        this.initialize();
    }

    @Override
    public void initialize() {
        double d;
        super.initialize();
        double d2 = Math.abs(this.projectionLatitude);
        this.mode = Math.abs(d - 1.5707963267948966) < 1.0E-10 ? (this.projectionLatitude < 0.0 ? 2 : 1) : (d2 > 1.0E-10 ? 4 : 3);
        this.trueScaleLatitude = Math.abs(this.trueScaleLatitude);
        if (!this.spherical) {
            switch (this.mode) {
                case 1: 
                case 2: {
                    if (Math.abs(this.trueScaleLatitude - 1.5707963267948966) < 1.0E-10) {
                        this.akm1 = 2.0 * this.scaleFactor / Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e));
                        break;
                    }
                    d2 = Math.sin(this.trueScaleLatitude);
                    this.akm1 = Math.cos(this.trueScaleLatitude) / ProjectionMath.tsfn(this.trueScaleLatitude, d2, this.e);
                    this.akm1 /= Math.sqrt(1.0 - (d2 *= this.e) * d2);
                    break;
                }
                case 3: {
                    this.akm1 = 2.0 * this.scaleFactor;
                    break;
                }
                case 4: {
                    d2 = Math.sin(this.projectionLatitude);
                    double d3 = 2.0 * Math.atan(this.ssfn(this.projectionLatitude, d2, this.e)) - 1.5707963267948966;
                    this.akm1 = 2.0 * this.scaleFactor * Math.cos(this.projectionLatitude) / Math.sqrt(1.0 - (d2 *= this.e) * d2);
                    this.sinphi0 = Math.sin(d3);
                    this.cosphi0 = Math.cos(d3);
                }
            }
        } else {
            switch (this.mode) {
                case 4: {
                    this.sinphi0 = Math.sin(this.projectionLatitude);
                    this.cosphi0 = Math.cos(this.projectionLatitude);
                }
                case 3: {
                    this.akm1 = 2.0 * this.scaleFactor;
                    break;
                }
                case 1: 
                case 2: {
                    this.akm1 = Math.abs(this.trueScaleLatitude - 1.5707963267948966) >= 1.0E-10 ? Math.cos(this.trueScaleLatitude) / Math.tan(0.7853981633974483 - 0.5 * this.trueScaleLatitude) : 2.0 * this.scaleFactor;
                }
            }
        }
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.cos(d);
        double d4 = Math.sin(d);
        double d5 = Math.sin(d2);
        if (this.spherical) {
            double d6 = Math.cos(d2);
            switch (this.mode) {
                case 3: {
                    projCoordinate.y = 1.0 + d6 * d3;
                    if (projCoordinate.y <= 1.0E-10) {
                        throw new ProjectionException();
                    }
                    projCoordinate.y = this.akm1 / projCoordinate.y;
                    projCoordinate.x = projCoordinate.y * d6 * d4;
                    projCoordinate.y *= d5;
                    break;
                }
                case 4: {
                    projCoordinate.y = 1.0 + this.sinphi0 * d5 + this.cosphi0 * d6 * d3;
                    if (projCoordinate.y <= 1.0E-10) {
                        throw new ProjectionException();
                    }
                    projCoordinate.y = this.akm1 / projCoordinate.y;
                    projCoordinate.x = projCoordinate.y * d6 * d4;
                    projCoordinate.y *= this.cosphi0 * d5 - this.sinphi0 * d6 * d3;
                    break;
                }
                case 1: {
                    d3 = -d3;
                    d2 = -d2;
                }
                case 2: {
                    if (Math.abs(d2 - 1.5707963267948966) < 1.0E-8) {
                        throw new ProjectionException();
                    }
                    projCoordinate.y = this.akm1 * Math.tan(0.7853981633974483 + 0.5 * d2);
                    projCoordinate.x = d4 * projCoordinate.y;
                    projCoordinate.y *= d3;
                }
            }
        } else {
            double d7 = 0.0;
            double d8 = 0.0;
            if (this.mode == 4 || this.mode == 3) {
                double d9 = 2.0 * Math.atan(this.ssfn(d2, d5, this.e)) - 1.5707963267948966;
                d7 = Math.sin(d9);
                d8 = Math.cos(d9);
            }
            switch (this.mode) {
                case 4: {
                    double d10 = this.akm1 / (this.cosphi0 * (1.0 + this.sinphi0 * d7 + this.cosphi0 * d8 * d3));
                    projCoordinate.y = d10 * (this.cosphi0 * d7 - this.sinphi0 * d8 * d3);
                    projCoordinate.x = d10 * d8;
                    break;
                }
                case 3: {
                    double d11 = 2.0 * this.akm1 / (1.0 + d8 * d3);
                    projCoordinate.y = d11 * d7;
                    projCoordinate.x = d11 * d8;
                    break;
                }
                case 2: {
                    d2 = -d2;
                    d3 = -d3;
                    d5 = -d5;
                }
                case 1: {
                    projCoordinate.x = this.akm1 * ProjectionMath.tsfn(d2, d5, this.e);
                    projCoordinate.y = -projCoordinate.x * d3;
                }
            }
            projCoordinate.x *= d4;
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3 = ProjectionMath.distance(d, d2);
            double d4 = 2.0 * Math.atan(d3 / this.akm1);
            double d5 = Math.sin(d4);
            double d6 = Math.cos(d4);
            projCoordinate.x = 0.0;
            switch (this.mode) {
                case 3: {
                    projCoordinate.y = Math.abs(d3) <= 1.0E-10 ? 0.0 : Math.asin(d2 * d5 / d3);
                    if (d6 == 0.0 && d == 0.0) break;
                    projCoordinate.x = Math.atan2(d * d5, d6 * d3);
                    break;
                }
                case 4: {
                    projCoordinate.y = Math.abs(d3) <= 1.0E-10 ? this.projectionLatitude : Math.asin(d6 * this.sinphi0 + d2 * d5 * this.cosphi0 / d3);
                    d4 = d6 - this.sinphi0 * Math.sin(projCoordinate.y);
                    if (d4 == 0.0 && d == 0.0) break;
                    projCoordinate.x = Math.atan2(d * d5 * this.cosphi0, d4 * d3);
                    break;
                }
                case 1: {
                    d2 = -d2;
                }
                case 2: {
                    projCoordinate.y = Math.abs(d3) <= 1.0E-10 ? this.projectionLatitude : Math.asin(this.mode == 2 ? -d6 : d6);
                    projCoordinate.x = d == 0.0 && d2 == 0.0 ? 0.0 : Math.atan2(d, d2);
                }
            }
        } else {
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12 = ProjectionMath.distance(d, d2);
            switch (this.mode) {
                default: {
                    d11 = 2.0 * Math.atan2(d12 * this.cosphi0, this.akm1);
                    double d13 = Math.cos(d11);
                    d10 = Math.sin(d11);
                    d9 = Math.asin(d13 * this.sinphi0 + d2 * d10 * this.cosphi0 / d12);
                    d11 = Math.tan(0.5 * (1.5707963267948966 + d9));
                    d *= d10;
                    d2 = d12 * this.cosphi0 * d13 - d2 * this.sinphi0 * d10;
                    d8 = 1.5707963267948966;
                    d7 = 0.5 * this.e;
                    break;
                }
                case 1: {
                    d2 = -d2;
                }
                case 2: {
                    d11 = -d12 / this.akm1;
                    d9 = 1.5707963267948966 - 2.0 * Math.atan(d11);
                    d8 = -1.5707963267948966;
                    d7 = -0.5 * this.e;
                }
            }
            int n = 8;
            while (n-- != 0) {
                d10 = this.e * Math.sin(d9);
                projCoordinate.y = 2.0 * Math.atan(d11 * Math.pow((1.0 + d10) / (1.0 - d10), d7)) - d8;
                if (Math.abs(d9 - projCoordinate.y) < 1.0E-10) {
                    if (this.mode == 2) {
                        projCoordinate.y = -projCoordinate.y;
                    }
                    projCoordinate.x = d == 0.0 && d2 == 0.0 ? 0.0 : Math.atan2(d, d2);
                    return projCoordinate;
                }
                d9 = projCoordinate.y;
            }
            throw new ConvergenceFailureException("Iteration didn't converge");
        }
        return projCoordinate;
    }

    @Override
    public boolean isConformal() {
        return true;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    private double ssfn(double d, double d2, double d3) {
        return Math.tan(0.5 * (1.5707963267948966 + d)) * Math.pow((1.0 - (d2 *= d3)) / (1.0 + d2), 0.5 * d3);
    }

    @Override
    public String toString() {
        return "Stereographic Azimuthal";
    }
}

