/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import java.text.FieldPosition;
import org.osgeo.proj4j.InvalidValueException;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.Ellipsoid;
import org.osgeo.proj4j.units.AngleFormat;
import org.osgeo.proj4j.units.Unit;
import org.osgeo.proj4j.units.Units;
import org.osgeo.proj4j.util.ProjectionMath;

public abstract class Projection
implements Cloneable {
    protected double minLatitude = -1.5707963267948966;
    protected double minLongitude = -Math.PI;
    protected double maxLatitude = 1.5707963267948966;
    protected double maxLongitude = Math.PI;
    protected double projectionLatitude = 0.0;
    protected double projectionLongitude = 0.0;
    protected double projectionLatitude1 = 0.0;
    protected double projectionLatitude2 = 0.0;
    protected double alpha = Double.NaN;
    protected double lonc = Double.NaN;
    protected double scaleFactor = 1.0;
    protected double falseEasting = 0.0;
    protected double falseNorthing = 0.0;
    protected boolean isSouth = false;
    protected double trueScaleLatitude = 0.0;
    protected double a = 0.0;
    protected double e = 0.0;
    protected double es = 0.0;
    protected double one_es = 0.0;
    protected double rone_es = 0.0;
    protected Ellipsoid ellipsoid;
    protected boolean spherical;
    protected boolean geocentric;
    protected String name = null;
    protected double fromMetres = 1.0;
    protected double totalScale = 0.0;
    private double totalFalseEasting = 0.0;
    private double totalFalseNorthing = 0.0;
    protected Unit unit = null;
    protected static final double EPS10 = 1.0E-10;
    protected static final double RTD = 57.29577951308232;
    protected static final double DTR = Math.PI / 180;

    protected Projection() {
        this.setEllipsoid(Ellipsoid.SPHERE);
    }

    public Object clone() {
        try {
            Projection projection = (Projection)super.clone();
            return projection;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ProjCoordinate project(ProjCoordinate projCoordinate, ProjCoordinate projCoordinate2) {
        double d = projCoordinate.x * (Math.PI / 180);
        if (this.projectionLongitude != 0.0) {
            d = ProjectionMath.normalizeLongitude(d - this.projectionLongitude);
        }
        return this.projectRadians(d, projCoordinate.y * (Math.PI / 180), projCoordinate2);
    }

    public ProjCoordinate projectRadians(ProjCoordinate projCoordinate, ProjCoordinate projCoordinate2) {
        double d = projCoordinate.x;
        if (this.projectionLongitude != 0.0) {
            d = ProjectionMath.normalizeLongitude(d - this.projectionLongitude);
        }
        return this.projectRadians(d, projCoordinate.y, projCoordinate2);
    }

    private ProjCoordinate projectRadians(double d, double d2, ProjCoordinate projCoordinate) {
        this.project(d, d2, projCoordinate);
        if (this.unit == Units.DEGREES) {
            projCoordinate.x *= 57.29577951308232;
            projCoordinate.y *= 57.29577951308232;
        } else {
            projCoordinate.x = this.totalScale * projCoordinate.x + this.totalFalseEasting;
            projCoordinate.y = this.totalScale * projCoordinate.y + this.totalFalseNorthing;
        }
        return projCoordinate;
    }

    protected ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = d;
        projCoordinate.y = d2;
        return projCoordinate;
    }

    public ProjCoordinate inverseProject(ProjCoordinate projCoordinate, ProjCoordinate projCoordinate2) {
        this.inverseProjectRadians(projCoordinate, projCoordinate2);
        projCoordinate2.x *= 57.29577951308232;
        projCoordinate2.y *= 57.29577951308232;
        return projCoordinate2;
    }

    public ProjCoordinate inverseProjectRadians(ProjCoordinate projCoordinate, ProjCoordinate projCoordinate2) {
        double d;
        double d2;
        if (this.unit == Units.DEGREES) {
            d2 = projCoordinate.x * (Math.PI / 180);
            d = projCoordinate.y * (Math.PI / 180);
        } else {
            d2 = (projCoordinate.x - this.totalFalseEasting) / this.totalScale;
            d = (projCoordinate.y - this.totalFalseNorthing) / this.totalScale;
        }
        this.projectInverse(d2, d, projCoordinate2);
        if (projCoordinate2.x < -Math.PI) {
            projCoordinate2.x = -Math.PI;
        } else if (projCoordinate2.x > Math.PI) {
            projCoordinate2.x = Math.PI;
        }
        if (this.projectionLongitude != 0.0) {
            projCoordinate2.x = ProjectionMath.normalizeLongitude(projCoordinate2.x + this.projectionLongitude);
        }
        return projCoordinate2;
    }

    protected ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.x = d;
        projCoordinate.y = d2;
        return projCoordinate;
    }

    public boolean isConformal() {
        return false;
    }

    public boolean isEqualArea() {
        return false;
    }

    public boolean hasInverse() {
        return false;
    }

    public boolean isRectilinear() {
        return false;
    }

    public boolean parallelsAreParallel() {
        return this.isRectilinear();
    }

    public boolean inside(double d, double d2) {
        return this.minLongitude <= (d = (double)Projection.normalizeLongitude((float)(d * (Math.PI / 180) - this.projectionLongitude))) && d <= this.maxLongitude && this.minLatitude <= d2 && d2 <= this.maxLatitude;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.toString();
    }

    public String getPROJ4Description() {
        AngleFormat angleFormat = new AngleFormat("DdM", false);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("+proj=" + this.getName() + " +a=" + this.a);
        if (this.es != 0.0) {
            stringBuffer.append(" +es=" + this.es);
        }
        stringBuffer.append(" +lon_0=");
        angleFormat.format(this.projectionLongitude, stringBuffer, (FieldPosition)null);
        stringBuffer.append(" +lat_0=");
        angleFormat.format(this.projectionLatitude, stringBuffer, (FieldPosition)null);
        if (this.falseEasting != 1.0) {
            stringBuffer.append(" +x_0=" + this.falseEasting);
        }
        if (this.falseNorthing != 1.0) {
            stringBuffer.append(" +y_0=" + this.falseNorthing);
        }
        if (this.scaleFactor != 1.0) {
            stringBuffer.append(" +k=" + this.scaleFactor);
        }
        if (this.fromMetres != 1.0) {
            stringBuffer.append(" +fr_meters=" + this.fromMetres);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "None";
    }

    public void setMinLatitude(double d) {
        this.minLatitude = d;
    }

    public double getMinLatitude() {
        return this.minLatitude;
    }

    public void setMaxLatitude(double d) {
        this.maxLatitude = d;
    }

    public double getMaxLatitude() {
        return this.maxLatitude;
    }

    public double getMaxLatitudeDegrees() {
        return this.maxLatitude * 57.29577951308232;
    }

    public double getMinLatitudeDegrees() {
        return this.minLatitude * 57.29577951308232;
    }

    public void setMinLongitude(double d) {
        this.minLongitude = d;
    }

    public double getMinLongitude() {
        return this.minLongitude;
    }

    public void setMinLongitudeDegrees(double d) {
        this.minLongitude = Math.PI / 180 * d;
    }

    public double getMinLongitudeDegrees() {
        return this.minLongitude * 57.29577951308232;
    }

    public void setMaxLongitude(double d) {
        this.maxLongitude = d;
    }

    public double getMaxLongitude() {
        return this.maxLongitude;
    }

    public void setMaxLongitudeDegrees(double d) {
        this.maxLongitude = Math.PI / 180 * d;
    }

    public double getMaxLongitudeDegrees() {
        return this.maxLongitude * 57.29577951308232;
    }

    public void setProjectionLatitude(double d) {
        this.projectionLatitude = d;
    }

    public double getProjectionLatitude() {
        return this.projectionLatitude;
    }

    public void setProjectionLatitudeDegrees(double d) {
        this.projectionLatitude = Math.PI / 180 * d;
    }

    public double getProjectionLatitudeDegrees() {
        return this.projectionLatitude * 57.29577951308232;
    }

    public void setProjectionLongitude(double d) {
        this.projectionLongitude = Projection.normalizeLongitudeRadians(d);
    }

    public double getProjectionLongitude() {
        return this.projectionLongitude;
    }

    public void setProjectionLongitudeDegrees(double d) {
        this.projectionLongitude = Math.PI / 180 * d;
    }

    public double getProjectionLongitudeDegrees() {
        return this.projectionLongitude * 57.29577951308232;
    }

    public void setTrueScaleLatitude(double d) {
        this.trueScaleLatitude = d;
    }

    public double getTrueScaleLatitude() {
        return this.trueScaleLatitude;
    }

    public void setTrueScaleLatitudeDegrees(double d) {
        this.trueScaleLatitude = Math.PI / 180 * d;
    }

    public double getTrueScaleLatitudeDegrees() {
        return this.trueScaleLatitude * 57.29577951308232;
    }

    public void setProjectionLatitude1(double d) {
        this.projectionLatitude1 = d;
    }

    public double getProjectionLatitude1() {
        return this.projectionLatitude1;
    }

    public void setProjectionLatitude1Degrees(double d) {
        this.projectionLatitude1 = Math.PI / 180 * d;
    }

    public double getProjectionLatitude1Degrees() {
        return this.projectionLatitude1 * 57.29577951308232;
    }

    public void setProjectionLatitude2(double d) {
        this.projectionLatitude2 = d;
    }

    public double getProjectionLatitude2() {
        return this.projectionLatitude2;
    }

    public void setProjectionLatitude2Degrees(double d) {
        this.projectionLatitude2 = Math.PI / 180 * d;
    }

    public double getProjectionLatitude2Degrees() {
        return this.projectionLatitude2 * 57.29577951308232;
    }

    public void setAlphaDegrees(double d) {
        this.alpha = Math.PI / 180 * d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setLonCDegrees(double d) {
        this.lonc = Math.PI / 180 * d;
    }

    public double getLonC() {
        return this.lonc;
    }

    public void setFalseNorthing(double d) {
        this.falseNorthing = d;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public void setFalseEasting(double d) {
        this.falseEasting = d;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public void setSouthernHemisphere(boolean bl) {
        this.isSouth = bl;
    }

    public boolean getSouthernHemisphere() {
        return this.isSouth;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getEquatorRadius() {
        return this.a;
    }

    public void setFromMetres(double d) {
        this.fromMetres = d;
    }

    public double getFromMetres() {
        return this.fromMetres;
    }

    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
        this.a = ellipsoid.equatorRadius;
        this.e = ellipsoid.eccentricity;
        this.es = ellipsoid.eccentricity2;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public int getEPSGCode() {
        return 0;
    }

    public void setUnits(Unit unit) {
        this.unit = unit;
    }

    public void initialize() {
        this.spherical = this.e == 0.0;
        this.one_es = 1.0 - this.es;
        this.rone_es = 1.0 / this.one_es;
        this.totalScale = this.a * this.fromMetres;
        this.totalFalseEasting = this.falseEasting * this.fromMetres;
        this.totalFalseNorthing = this.falseNorthing * this.fromMetres;
    }

    public static float normalizeLongitude(float f) {
        if (Double.isInfinite(f) || Double.isNaN(f)) {
            throw new InvalidValueException("Infinite or NaN longitude");
        }
        while (f > 180.0f) {
            f -= 360.0f;
        }
        while (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static double normalizeLongitudeRadians(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new InvalidValueException("Infinite or NaN longitude");
        }
        while (d > Math.PI) {
            d -= Math.PI * 2;
        }
        while (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }
}

