/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.AzimuthalProjection;
import org.osgeo.proj4j.util.ProjectionMath;

public class OrthographicAzimuthalProjection
extends AzimuthalProjection {
    public OrthographicAzimuthalProjection() {
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.cos(d2);
        double d4 = Math.cos(d);
        switch (this.mode) {
            case 3: {
                projCoordinate.y = Math.sin(d2);
                break;
            }
            case 4: {
                double d5 = Math.sin(d2);
                projCoordinate.y = this.cosphi0 * d5 - this.sinphi0 * d3 * d4;
                break;
            }
            case 1: {
                d4 = -d4;
            }
            case 2: {
                projCoordinate.y = d3 * d4;
            }
        }
        projCoordinate.x = d3 * Math.sin(d);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4;
        double d5 = d4 = ProjectionMath.distance(d, d2);
        if (d3 > 1.0) {
            if (d5 - 1.0 > 1.0E-10) {
                throw new ProjectionException();
            }
            d5 = 1.0;
        }
        double d6 = Math.sqrt(1.0 - d5 * d5);
        if (Math.abs(d4) <= 1.0E-10) {
            projCoordinate.y = this.projectionLatitude;
        } else {
            switch (this.mode) {
                case 1: {
                    d2 = -d2;
                    projCoordinate.y = Math.acos(d5);
                    break;
                }
                case 2: {
                    projCoordinate.y = -Math.acos(d5);
                    break;
                }
                case 3: {
                    projCoordinate.y = d2 * d5 / d4;
                    d *= d5;
                    d2 = d6 * d4;
                    if (Math.abs(projCoordinate.y) >= 1.0) {
                        projCoordinate.y = projCoordinate.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                        break;
                    }
                    projCoordinate.y = Math.asin(projCoordinate.y);
                    break;
                }
                case 4: {
                    projCoordinate.y = d6 * this.sinphi0 + d2 * d5 * this.cosphi0 / d4;
                    d2 = (d6 - this.sinphi0 * projCoordinate.y) * d4;
                    d *= d5 * this.cosphi0;
                    projCoordinate.y = Math.abs(projCoordinate.y) >= 1.0 ? (projCoordinate.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(projCoordinate.y);
                }
            }
        }
        projCoordinate.x = d2 == 0.0 && (this.mode == 4 || this.mode == 3) ? (d == 0.0 ? 0.0 : (d < 0.0 ? -1.5707963267948966 : 1.5707963267948966)) : Math.atan2(d, d2);
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Orthographic Azimuthal";
    }
}

