/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class LandsatProjection
extends Projection {
    private double a2;
    private double a4;
    private double b;
    private double c1;
    private double c3;
    private double q;
    private double t;
    private double u;
    private double w;
    private double p22;
    private double sa;
    private double ca;
    private double xj;
    private double rlm;
    private double rlm2;
    private static final double TOL = 1.0E-7;
    private static final double PI_HALFPI = 4.71238898038469;
    private static final double TWOPI_HALFPI = 7.853981633974483;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        double d3 = 0.0;
        double d4 = 0.0;
        if (d2 > 1.5707963267948966) {
            d2 = 1.5707963267948966;
        } else if (d2 < -1.5707963267948966) {
            d2 = -1.5707963267948966;
        }
        double d5 = d2 >= 0.0 ? 1.5707963267948966 : 4.71238898038469;
        double d6 = Math.tan(d2);
        int n2 = 0;
        while (true) {
            double d7 = d5;
            double d8 = d + this.p22 * d5;
            double d9 = Math.cos(d8);
            if (Math.abs(d9) < 1.0E-7) {
                d8 -= 1.0E-7;
            }
            double d10 = d5 - Math.sin(d5) * (d9 < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
            for (n = 50; n > 0; --n) {
                double d11;
                d3 = d + this.p22 * d7;
                double d12 = Math.cos(d3);
                if (Math.abs(d11) < 1.0E-7) {
                    d3 -= 1.0E-7;
                }
                double d13 = (this.one_es * d6 * this.sa + Math.sin(d3) * this.ca) / d12;
                d4 = Math.atan(d13) + d10;
                if (Math.abs(Math.abs(d7) - Math.abs(d4)) < 1.0E-7) break;
                d7 = d4;
            }
            if (n == 0 || ++n2 >= 3 || d4 > this.rlm && d4 < this.rlm2) break;
            if (d4 <= this.rlm) {
                d5 = 7.853981633974483;
                continue;
            }
            if (!(d4 >= this.rlm2)) continue;
            d5 = 1.5707963267948966;
        }
        if (n != 0) {
            double d14 = Math.sin(d2);
            double d15 = ProjectionMath.asin((this.one_es * this.ca * d14 - this.sa * Math.cos(d2) * Math.sin(d3)) / Math.sqrt(1.0 - this.es * d14 * d14));
            double d16 = Math.log(Math.tan(0.7853981633974483 + 0.5 * d15));
            double d17 = Math.sin(d4);
            double d18 = d17 * d17;
            double d19 = this.p22 * this.sa * Math.cos(d4) * Math.sqrt((1.0 + this.t * d18) / ((1.0 + this.w * d18) * (1.0 + this.q * d18)));
            double d20 = Math.sqrt(this.xj * this.xj + d19 * d19);
            projCoordinate.x = this.b * d4 + this.a2 * Math.sin(2.0 * d4) + this.a4 * Math.sin(d4 * 4.0) - d16 * d19 / d20;
            projCoordinate.y = this.c1 * d17 + this.c3 * Math.sin(d4 * 3.0) + d16 * this.xj / d20;
        } else {
            projCoordinate.y = Double.POSITIVE_INFINITY;
            projCoordinate.x = Double.POSITIVE_INFINITY;
        }
        return projCoordinate;
    }

    private void seraz0(double d, double d2) {
        double d3 = Math.sin(d *= Math.PI / 180);
        double d4 = d3 * d3;
        double d5 = this.p22 * this.sa * Math.cos(d) * Math.sqrt((1.0 + this.t * d4) / ((1.0 + this.w * d4) * (1.0 + this.q * d4)));
        double d6 = 1.0 + this.q * d4;
        double d7 = Math.sqrt((1.0 + this.q * d4) / (1.0 + this.w * d4)) * ((1.0 + this.w * d4) / (d6 * d6) - this.p22 * this.ca);
        double d8 = Math.sqrt(this.xj * this.xj + d5 * d5);
        double d9 = d2 * (d7 * this.xj - d5 * d5) / d8;
        this.b += d9;
        this.a2 += d9 * Math.cos(d + d);
        this.a4 += d9 * Math.cos(d * 4.0);
        d9 = d2 * d5 * (d7 + this.xj) / d8;
        this.c1 += d9 * Math.cos(d);
        this.c3 += d9 * Math.cos(d * 3.0);
    }

    @Override
    public void initialize() {
        double d;
        double d2;
        super.initialize();
        int n = 1;
        if (n <= 0 || n > 5) {
            throw new ProjectionException("-28");
        }
        int n2 = 120;
        if (n2 <= 0 || n2 > (n <= 3 ? 251 : 233)) {
            throw new ProjectionException("-29");
        }
        if (n <= 3) {
            this.projectionLongitude = 2.2492058070450924 - 0.025032610785576042 * (double)n2;
            this.p22 = 103.2669323;
            d2 = 1.729481662386221;
        } else {
            this.projectionLongitude = 2.2567107228286685 - 0.026966460545835135 * (double)n2;
            this.p22 = 98.8841202;
            d2 = 1.7139133254584316;
        }
        this.p22 /= 1440.0;
        this.sa = Math.sin(d2);
        this.ca = Math.cos(d2);
        if (Math.abs(this.ca) < 1.0E-9) {
            this.ca = 1.0E-9;
        }
        double d3 = this.es * this.ca * this.ca;
        double d4 = this.es * this.sa * this.sa;
        this.w = (1.0 - d3) * this.rone_es;
        this.w = this.w * this.w - 1.0;
        this.q = d4 * this.rone_es;
        this.t = d4 * (2.0 - this.es) * this.rone_es * this.rone_es;
        this.u = d3 * this.rone_es;
        this.xj = this.one_es * this.one_es * this.one_es;
        this.rlm = 1.6341348883592068;
        this.rlm2 = this.rlm + Math.PI * 2;
        this.c3 = 0.0;
        this.c1 = 0.0;
        this.b = 0.0;
        this.a4 = 0.0;
        this.a2 = 0.0;
        this.seraz0(0.0, 1.0);
        for (d = 9.0; d <= 81.0001; d += 18.0) {
            this.seraz0(d, 4.0);
        }
        for (d = 18.0; d <= 72.0001; d += 18.0) {
            this.seraz0(d, 2.0);
        }
        this.seraz0(90.0, 1.0);
        this.a2 /= 30.0;
        this.a4 /= 60.0;
        this.b /= 30.0;
        this.c1 /= 15.0;
        this.c3 /= 45.0;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Landsat";
    }
}

