/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.PseudoCylindricalProjection;

public class HammerProjection
extends PseudoCylindricalProjection {
    private double w = 0.5;
    private double m = 1.0;
    private double rm;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = Math.cos(d2);
        double d4 = Math.sqrt(2.0 / (1.0 + d3 * Math.cos(d *= this.w)));
        projCoordinate.x = this.m * d4 * d3 * Math.sin(d);
        projCoordinate.y = this.rm * d4 * Math.sin(d2);
        return projCoordinate;
    }

    @Override
    public void initialize() {
        double d;
        double d2;
        super.initialize();
        this.w = Math.abs(this.w);
        if (d2 <= 0.0) {
            throw new ProjectionException("-27");
        }
        this.w = 0.5;
        this.m = Math.abs(this.m);
        if (d <= 0.0) {
            throw new ProjectionException("-27");
        }
        this.m = 1.0;
        this.rm = 1.0 / this.m;
        this.m /= this.w;
        this.es = 0.0;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    public void setW(double d) {
        this.w = d;
    }

    public double getW() {
        return this.w;
    }

    public void setM(double d) {
        this.m = d;
    }

    public double getM() {
        return this.m;
    }

    @Override
    public String toString() {
        return "Hammer & Eckert-Greifendorff";
    }
}

