/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class CylindricalEqualAreaProjection
extends Projection {
    private double qp;
    private double[] apa;
    private double trueScaleLatitude;

    public CylindricalEqualAreaProjection() {
        this(0.0, 0.0, 0.0);
    }

    public CylindricalEqualAreaProjection(double d, double d2, double d3) {
        this.projectionLatitude = d;
        this.projectionLongitude = d2;
        this.trueScaleLatitude = d3;
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        double d = this.trueScaleLatitude;
        this.scaleFactor = Math.cos(d);
        if (this.es != 0.0) {
            d = Math.sin(d);
            this.scaleFactor /= Math.sqrt(1.0 - this.es * d * d);
            this.apa = ProjectionMath.authset(this.es);
            this.qp = ProjectionMath.qsfn(1.0, this.e, this.one_es);
        }
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            projCoordinate.x = this.scaleFactor * d;
            projCoordinate.y = Math.sin(d2) / this.scaleFactor;
        } else {
            projCoordinate.x = this.scaleFactor * d;
            projCoordinate.y = 0.5 * ProjectionMath.qsfn(Math.sin(d2), this.e, this.one_es) / this.scaleFactor;
        }
        return projCoordinate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            double d3;
            double d4 = Math.abs(d2 *= this.scaleFactor);
            if (!(d3 - 1.0E-10 <= 1.0)) throw new ProjectionException();
            projCoordinate.y = d4 >= 1.0 ? (d2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(d2);
            projCoordinate.x = d / this.scaleFactor;
            return projCoordinate;
        } else {
            projCoordinate.y = ProjectionMath.authlat(Math.asin(2.0 * d2 * this.scaleFactor / this.qp), this.apa);
            projCoordinate.x = d / this.scaleFactor;
        }
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isRectilinear() {
        return true;
    }
}

