/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.CylindricalProjection;

public class CentralCylindricalProjection
extends CylindricalProjection {
    private double ap;
    private static final double EPS10 = 1.0E-10;

    public CentralCylindricalProjection() {
        this.minLatitude = Math.toRadians(-80.0);
        this.maxLatitude = Math.toRadians(80.0);
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (Math.abs(Math.abs(d2) - 1.5707963267948966) <= 1.0E-10) {
            throw new ProjectionException("F");
        }
        projCoordinate.x = d;
        projCoordinate.y = Math.tan(d2);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = Math.atan(d2);
        projCoordinate.x = d;
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Central Cylindrical";
    }
}

