/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class CassiniProjection
extends Projection {
    private double m0;
    private double n;
    private double t;
    private double a1;
    private double c;
    private double r;
    private double dd;
    private double d2;
    private double a2;
    private double tn;
    private double[] en;
    private static final double EPS10 = 1.0E-10;
    private static final double C1 = 0.16666666666666666;
    private static final double C2 = 0.008333333333333333;
    private static final double C3 = 0.041666666666666664;
    private static final double C4 = 0.3333333333333333;
    private static final double C5 = 0.06666666666666667;

    public CassiniProjection() {
        this.projectionLatitude = Math.toRadians(0.0);
        this.projectionLongitude = Math.toRadians(0.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            projCoordinate.x = Math.asin(Math.cos(d2) * Math.sin(d));
            projCoordinate.y = Math.atan2(Math.tan(d2), Math.cos(d)) - this.projectionLatitude;
        } else {
            this.n = Math.sin(d2);
            this.c = Math.cos(d2);
            projCoordinate.y = ProjectionMath.mlfn(d2, this.n, this.c, this.en);
            this.n = 1.0 / Math.sqrt(1.0 - this.es * this.n * this.n);
            this.tn = Math.tan(d2);
            this.t = this.tn * this.tn;
            this.a1 = d * this.c;
            this.c *= this.es * this.c / (1.0 - this.es);
            this.a2 = this.a1 * this.a1;
            projCoordinate.x = this.n * this.a1 * (1.0 - this.a2 * this.t * (0.16666666666666666 - (8.0 - this.t + 8.0 * this.c) * this.a2 * 0.008333333333333333));
            projCoordinate.y -= this.m0 - this.n * this.tn * this.a2 * (0.5 + (5.0 - this.t + 6.0 * this.c) * this.a2 * 0.041666666666666664);
        }
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        if (this.spherical) {
            this.dd = d2 + this.projectionLatitude;
            projCoordinate.y = Math.asin(Math.sin(this.dd) * Math.cos(d));
            projCoordinate.x = Math.atan2(Math.tan(d), Math.cos(this.dd));
        } else {
            double d3 = ProjectionMath.inv_mlfn(this.m0 + d2, this.es, this.en);
            this.tn = Math.tan(d3);
            this.t = this.tn * this.tn;
            this.n = Math.sin(d3);
            this.r = 1.0 / (1.0 - this.es * this.n * this.n);
            this.n = Math.sqrt(this.r);
            this.r *= (1.0 - this.es) * this.n;
            this.dd = d / this.n;
            this.d2 = this.dd * this.dd;
            projCoordinate.y = d3 - this.n * this.tn / this.r * this.d2 * (0.5 - (1.0 + 3.0 * this.t) * this.d2 * 0.041666666666666664);
            projCoordinate.x = this.dd * (1.0 + this.t * this.d2 * (-0.3333333333333333 + (1.0 + 3.0 * this.t) * this.d2 * 0.06666666666666667)) / Math.cos(d3);
        }
        return projCoordinate;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            if (this.en == null) {
                throw new ProjectionException();
            }
            this.m0 = ProjectionMath.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
        }
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public int getEPSGCode() {
        return 9806;
    }

    @Override
    public String toString() {
        return "Cassini";
    }
}

