/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.parser;

import java.util.HashMap;
import java.util.Map;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.InvalidValueException;
import org.osgeo.proj4j.Registry;
import org.osgeo.proj4j.datum.Datum;
import org.osgeo.proj4j.datum.Ellipsoid;
import org.osgeo.proj4j.parser.DatumParameters;
import org.osgeo.proj4j.parser.Proj4Keyword;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.proj.TransverseMercatorProjection;
import org.osgeo.proj4j.units.AngleFormat;
import org.osgeo.proj4j.units.Unit;
import org.osgeo.proj4j.units.Units;

public class Proj4Parser {
    private Registry registry;
    private static AngleFormat format = new AngleFormat("DdM", true);

    public Proj4Parser(Registry registry) {
        this.registry = registry;
    }

    public CoordinateReferenceSystem parse(String string, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Map map = this.createParameterMap(stringArray);
        Proj4Keyword.checkUnsupported(map.keySet());
        DatumParameters datumParameters = new DatumParameters();
        this.parseDatum(map, datumParameters);
        this.parseEllipsoid(map, datumParameters);
        Datum datum = datumParameters.getDatum();
        Ellipsoid ellipsoid = datum.getEllipsoid();
        Projection projection = this.parseProjection(map, ellipsoid);
        return new CoordinateReferenceSystem(string, stringArray, datum, projection);
    }

    private Projection parseProjection(Map map, Ellipsoid ellipsoid) {
        Unit unit;
        Projection projection = null;
        String string = (String)map.get("proj");
        if (string != null && (projection = this.registry.getProjection(string)) == null) {
            throw new InvalidValueException("Unknown projection: " + string);
        }
        projection.setEllipsoid(ellipsoid);
        string = (String)map.get("alpha");
        if (string != null) {
            projection.setAlphaDegrees(Double.parseDouble(string));
        }
        if ((string = (String)map.get("lonc")) != null) {
            projection.setLonCDegrees(Double.parseDouble(string));
        }
        if ((string = (String)map.get("lat_0")) != null) {
            projection.setProjectionLatitudeDegrees(Proj4Parser.parseAngle(string));
        }
        if ((string = (String)map.get("lon_0")) != null) {
            projection.setProjectionLongitudeDegrees(Proj4Parser.parseAngle(string));
        }
        if ((string = (String)map.get("lat_1")) != null) {
            projection.setProjectionLatitude1Degrees(Proj4Parser.parseAngle(string));
        }
        if ((string = (String)map.get("lat_2")) != null) {
            projection.setProjectionLatitude2Degrees(Proj4Parser.parseAngle(string));
        }
        if ((string = (String)map.get("lat_ts")) != null) {
            projection.setTrueScaleLatitudeDegrees(Proj4Parser.parseAngle(string));
        }
        if ((string = (String)map.get("x_0")) != null) {
            projection.setFalseEasting(Double.parseDouble(string));
        }
        if ((string = (String)map.get("y_0")) != null) {
            projection.setFalseNorthing(Double.parseDouble(string));
        }
        if ((string = (String)map.get("k_0")) == null) {
            string = (String)map.get("k");
        }
        if (string != null) {
            projection.setScaleFactor(Double.parseDouble(string));
        }
        if ((string = (String)map.get("units")) != null && (unit = Units.findUnits(string)) != null) {
            projection.setFromMetres(1.0 / unit.value);
            projection.setUnits(unit);
        }
        if ((string = (String)map.get("to_meter")) != null) {
            projection.setFromMetres(1.0 / Double.parseDouble(string));
        }
        if (map.containsKey("south")) {
            projection.setSouthernHemisphere(true);
        }
        if (projection instanceof TransverseMercatorProjection && (string = (String)map.get("zone")) != null) {
            ((TransverseMercatorProjection)projection).setUTMZone(Integer.parseInt(string));
        }
        projection.initialize();
        return projection;
    }

    private void parseDatum(Map map, DatumParameters datumParameters) {
        Object object;
        String string = (String)map.get("towgs84");
        if (string != null) {
            object = this.parseDatumTransform(string);
            datumParameters.setDatumTransform((double[])object);
        }
        if ((object = (Object)((String)map.get("datum"))) != null) {
            Datum datum = this.registry.getDatum((String)object);
            if (datum == null) {
                throw new InvalidValueException("Unknown datum: " + (String)object);
            }
            datumParameters.setDatum(datum);
        }
    }

    private double[] parseDatumTransform(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 3 && stringArray.length != 7) {
            throw new InvalidValueException("Invalid number of values (must be 3 or 7) in +towgs84: " + string);
        }
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    private void parseEllipsoid(Map map, DatumParameters datumParameters) {
        String string;
        double d = 0.0;
        String string2 = (String)map.get("ellps");
        if (string2 != null) {
            Ellipsoid ellipsoid = this.registry.getEllipsoid(string2);
            if (ellipsoid == null) {
                throw new InvalidValueException("Unknown ellipsoid: " + string2);
            }
            datumParameters.setEllipsoid(ellipsoid);
        }
        if ((string = (String)map.get("a")) != null) {
            double d2 = Double.parseDouble(string);
            datumParameters.setA(d2);
        }
        if ((string = (String)map.get("es")) != null) {
            double d3 = Double.parseDouble(string);
            datumParameters.setES(d3);
        }
        if ((string = (String)map.get("rf")) != null) {
            double d4 = Double.parseDouble(string);
            datumParameters.setRF(d4);
        }
        if ((string = (String)map.get("f")) != null) {
            double d5 = Double.parseDouble(string);
            datumParameters.setF(d5);
        }
        if ((string = (String)map.get("b")) != null) {
            d = Double.parseDouble(string);
            datumParameters.setB(d);
        }
        if (d == 0.0) {
            d = datumParameters.getA() * Math.sqrt(1.0 - datumParameters.getES());
        }
        this.parseEllipsoidModifiers(map, datumParameters);
    }

    private void parseEllipsoidModifiers(Map map, DatumParameters datumParameters) {
        if (map.containsKey("R_A")) {
            datumParameters.setR_A();
            return;
        }
    }

    private Map createParameterMap(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            if (!string2.startsWith("+")) continue;
            int n = string2.indexOf(61);
            if (n != -1) {
                string = string2.substring(1, n);
                String string3 = string2.substring(n + 1);
                hashMap.put(string, string3);
                continue;
            }
            string = string2.substring(1);
            hashMap.put(string, null);
        }
        return hashMap;
    }

    private static double parseAngle(String string) {
        return format.parse(string, null).doubleValue();
    }
}

