/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.datum;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.Ellipsoid;

public class Datum {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_WGS84 = 1;
    public static final int TYPE_3PARAM = 2;
    public static final int TYPE_7PARAM = 3;
    public static final int TYPE_GRIDSHIFT = 4;
    private static final double[] DEFAULT_TRANSFORM = new double[]{0.0, 0.0, 0.0};
    public static final Datum WGS84 = new Datum("WGS84", 0.0, 0.0, 0.0, Ellipsoid.WGS84, "WGS84");
    public static final Datum GGRS87 = new Datum("GGRS87", -199.87, 74.79, 246.62, Ellipsoid.GRS80, "Greek_Geodetic_Reference_System_1987");
    public static final Datum NAD83 = new Datum("NAD83", 0.0, 0.0, 0.0, Ellipsoid.GRS80, "North_American_Datum_1983");
    public static final Datum NAD27 = new Datum("NAD27", "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat", Ellipsoid.CLARKE_1866, "North_American_Datum_1927");
    public static final Datum POTSDAM = new Datum("potsdam", 606.0, 23.0, 413.0, Ellipsoid.BESSEL, "Potsdam Rauenberg 1950 DHDN");
    public static final Datum CARTHAGE = new Datum("carthage", -263.0, 6.0, 431.0, Ellipsoid.CLARKE_1880, "Carthage 1934 Tunisia");
    public static final Datum HERMANNSKOGEL = new Datum("hermannskogel", 653.0, -212.0, 449.0, Ellipsoid.BESSEL, "Hermannskogel");
    public static final Datum IRE65 = new Datum("ire65", 482.53, -130.596, 564.557, -1.042, -0.214, -0.631, 8.15, Ellipsoid.MOD_AIRY, "Ireland 1965");
    public static final Datum NZGD49 = new Datum("nzgd49", 59.47, -5.04, 187.44, 0.47, -0.1, 1.024, -4.5993, Ellipsoid.INTERNATIONAL, "New Zealand Geodetic Datum 1949");
    public static final Datum OSEB36 = new Datum("OSGB36", 446.448, -125.157, 542.06, 0.1502, 0.247, 0.8421, -20.4894, Ellipsoid.AIRY, "Airy 1830");
    String code;
    String name;
    Ellipsoid ellipsoid;
    double[] transform = DEFAULT_TRANSFORM;

    public Datum(String string, String string2, Ellipsoid ellipsoid, String string3) {
        this(string, (double[])null, ellipsoid, string3);
    }

    public Datum(String string, double d, double d2, double d3, Ellipsoid ellipsoid, String string2) {
        this(string, new double[]{d, d2, d3}, ellipsoid, string2);
    }

    public Datum(String string, double d, double d2, double d3, double d4, double d5, double d6, double d7, Ellipsoid ellipsoid, String string2) {
        this(string, new double[]{d, d2, d3, d4, d5, d4, d7}, ellipsoid, string2);
    }

    public Datum(String string, double[] dArray, Ellipsoid ellipsoid, String string2) {
        this.code = string;
        this.name = string2;
        this.ellipsoid = ellipsoid;
        if (dArray != null) {
            this.transform = dArray;
        }
    }

    public String getCode() {
        return this.code;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public double[] getTransformToWGS84() {
        return this.transform;
    }

    public int getTransformType() {
        if (this.transform == null) {
            return 1;
        }
        if (this.transform.length == 3) {
            return 2;
        }
        if (this.transform.length == 7) {
            return 3;
        }
        return 1;
    }

    public boolean hasTransformToWGS84() {
        return this.getTransformType() == 2 || this.getTransformType() == 3;
    }

    public boolean isEqual(Datum datum) {
        if (this.getTransformType() != datum.getTransformType()) {
            return false;
        }
        if (this.ellipsoid.getEquatorRadius() != this.ellipsoid.getEquatorRadius() && Math.abs(this.ellipsoid.getEccentricitySquared() - datum.ellipsoid.getEccentricitySquared()) > 5.0E-11) {
            return false;
        }
        if (this.getTransformType() == 2 || this.getTransformType() == 3) {
            for (int i = 0; i < this.transform.length; ++i) {
                if (this.transform[i] == datum.transform[i]) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void transformFromGeocentricToWgs84(ProjCoordinate projCoordinate) {
        if (this.transform.length == 3) {
            projCoordinate.x += this.transform[0];
            projCoordinate.y += this.transform[1];
            projCoordinate.z += this.transform[2];
        } else if (this.transform.length == 7) {
            double d = this.transform[0];
            double d2 = this.transform[1];
            double d3 = this.transform[2];
            double d4 = this.transform[3];
            double d5 = this.transform[4];
            double d6 = this.transform[5];
            double d7 = this.transform[6];
            double d8 = d7 * (projCoordinate.x - d6 * projCoordinate.y + d5 * projCoordinate.z) + d;
            double d9 = d7 * (d6 * projCoordinate.x + projCoordinate.y - d4 * projCoordinate.z) + d2;
            double d10 = d7 * (-d5 * projCoordinate.x + d4 * projCoordinate.y + projCoordinate.z) + d3;
            projCoordinate.x = d8;
            projCoordinate.y = d9;
            projCoordinate.z = d10;
        }
    }

    public void transformToGeocentricFromWgs84(ProjCoordinate projCoordinate) {
        if (this.transform.length == 3) {
            projCoordinate.x -= this.transform[0];
            projCoordinate.y -= this.transform[1];
            projCoordinate.z -= this.transform[2];
        } else if (this.transform.length == 7) {
            double d = this.transform[0];
            double d2 = this.transform[1];
            double d3 = this.transform[2];
            double d4 = this.transform[3];
            double d5 = this.transform[4];
            double d6 = this.transform[5];
            double d7 = this.transform[6];
            double d8 = (projCoordinate.x - d) / d7;
            double d9 = (projCoordinate.y - d2) / d7;
            double d10 = (projCoordinate.z - d3) / d7;
            projCoordinate.x = d8 + d6 * d9 - d5 * d10;
            projCoordinate.y = -d6 * d8 + d9 + d4 * d10;
            projCoordinate.z = d5 * d8 - d4 * d9 + d10;
        }
    }
}

