/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.OsbDialog;
import org.openstreetmap.josm.plugins.osb.gui.action.PopupFactory;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;

public class OsbLayer
extends Layer
implements MouseListener {
    private DataSet data;
    private Collection<? extends OsmPrimitive> selection;
    private JToolTip tooltip = new JToolTip();
    private static ImageIcon iconError = OsbPlugin.loadIcon("icon_error16.png");
    private static ImageIcon iconValid = OsbPlugin.loadIcon("icon_valid16.png");
    private OsbDialog dialog;

    public OsbLayer(DataSet dataSet, String name, OsbDialog dialog) {
        super(name);
        this.data = dataSet;
        this.dialog = dialog;
        DataSet.selListeners.add(new SelectionChangedListener(){

            public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
                OsbLayer.this.selection = newSelection;
            }
        });
        if (Main.map != null && Main.map.mapView != null) {
            Main.map.mapView.addMouseListener((MouseListener)this);
        }
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, (Layer)this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        return I18n.tr((String)"Displays OpenStreetBugs issues");
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        int height;
        int width;
        ImageIcon icon;
        Point p;
        Node node;
        Object[] nodes = this.data.getNodes().toArray();
        int i = 0;
        while (i < nodes.length) {
            node = (Node)nodes[i];
            if (node.isUsable()) {
                p = mv.getPoint(node);
                icon = "1".equals(node.get("state")) ? iconValid : iconError;
                width = icon.getIconWidth();
                height = icon.getIconHeight();
                g.drawImage(icon.getImage(), p.x - width / 2, p.y - height / 2, new ImageObserver(){

                    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                        return false;
                    }
                });
            }
            ++i;
        }
        if (this.selection == null) {
            return;
        }
        i = 0;
        while (i < nodes.length) {
            node = (Node)nodes[i];
            if (node.isUsable() && this.selection.contains(node)) {
                p = mv.getPoint(node);
                icon = "1".equals(node.get("state")) ? iconValid : iconError;
                width = icon.getIconWidth();
                height = icon.getIconHeight();
                g.setColor(ColorHelper.html2color((String)Main.pref.get("color.selected")));
                g.drawRect(p.x - width / 2, p.y - height / 2, width - 1, height - 1);
                String desc = node.get("note");
                if (desc != null) {
                    StringBuilder sb = new StringBuilder("<html>");
                    sb.append(desc.replaceAll("<hr />", "<hr>"));
                    sb.append("</html>");
                    desc = sb.toString();
                    this.tooltip.setTipText(desc);
                    int tx = p.x + width / 2 + 5;
                    int ty = p.y - height / 2 - 1;
                    g.translate(tx, ty);
                    int x = 0;
                    while (x < 2) {
                        Dimension d = this.tooltip.getUI().getPreferredSize(this.tooltip);
                        d.width = Math.min(d.width, mv.getWidth() * 2 / 3);
                        this.tooltip.setSize(d);
                        this.tooltip.paint(g);
                        ++x;
                    }
                    g.translate(-tx, -ty);
                }
            }
            ++i;
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Icon getIcon() {
        return OsbPlugin.loadIcon("icon_error16.png");
    }

    private Node getNearestNode(Point p) {
        double snapDistance = 10.0;
        double minDistanceSq = Double.MAX_VALUE;
        Node minPrimitive = null;
        for (Node n : this.data.getNodes()) {
            if (!n.isUsable()) continue;
            Point sp = Main.map.mapView.getPoint(n);
            double dist = p.distanceSq(sp);
            if (minDistanceSq > dist && p.distance(sp) < snapDistance) {
                minDistanceSq = p.distanceSq(sp);
                minPrimitive = n;
                continue;
            }
            if (minDistanceSq != dist || !this.data.isSelected((OsmPrimitive)n) || this.data.isSelected((OsmPrimitive)minPrimitive)) continue;
            minPrimitive = n;
        }
        return minPrimitive;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && Main.map.mapView.getActiveLayer() == this) {
            Node n = this.getNearestNode(e.getPoint());
            if (n != null && this.data.getNodes().contains(n)) {
                ArrayList<Node> selected = new ArrayList<Node>();
                selected.add(n);
                this.data.setSelected(selected);
            } else {
                this.data.setSelected(new ArrayList());
            }
            this.data.fireSelectionChanged();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.mayTriggerPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.mayTriggerPopup(e);
    }

    private void mayTriggerPopup(MouseEvent e) {
        Node n;
        if (e.isPopupTrigger() && Main.map.mapView.getActiveLayer() == this && (n = this.getNearestNode(e.getPoint())) != null && this.data.getNodes().contains(n)) {
            PopupFactory.createPopup(n, this.dialog).show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public DataSet getDataSet() {
        return this.data;
    }
}

