/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.action.NewIssueAction;
import org.openstreetmap.josm.tools.I18n;

public class PointToNewIssueAction
extends AbstractAction
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private JToggleButton button;
    private OsbPlugin plugin;
    private Cursor previousCursor;

    public PointToNewIssueAction(JToggleButton button, OsbPlugin plugin) {
        super(I18n.tr((String)"New issue"));
        this.button = button;
        this.plugin = plugin;
    }

    private void reset() {
        Main.map.mapView.setCursor(this.previousCursor);
        Main.map.mapView.removeMouseListener((MouseListener)this);
        this.button.setSelected(false);
    }

    public void mouseClicked(MouseEvent e) {
        this.addNewIssue(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.addNewIssue(e);
    }

    private void addNewIssue(MouseEvent e) {
        NewIssueAction nia = new NewIssueAction(this.plugin, e.getPoint());
        nia.actionPerformed(new ActionEvent(this, 0, ""));
        this.reset();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (this.button.isSelected()) {
            this.previousCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(new Cursor(1));
            Main.map.mapView.addMouseListener((MouseListener)this);
        } else {
            this.reset();
        }
    }
}

