/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.JunctionChecker.DigraphCreationTask;
import org.openstreetmap.josm.plugins.JunctionChecker.JunctionCheckerPlugin;
import org.openstreetmap.josm.plugins.JunctionChecker.PrepareJunctionCheckorSearch;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunctionCheckDialog
extends ToggleDialog
implements ActionListener,
SelectionChangedListener {
    private final JunctionCheckerPlugin plugin;
    private static final long serialVersionUID = 2952292777351992696L;
    private final SideButton checkJunctionButton;
    private final SideButton createDigraphButton;
    private final SideButton searchJunctionButton;
    private final JCheckBox digraphsealcb;
    private final JCheckBox produceRelation;
    private final JCheckBox sccCB;
    private final JSpinner nways;
    private final SpinnerNumberModel smodel;
    private final JLabel nwayslabel;

    public JunctionCheckDialog(JunctionCheckerPlugin junctionCheckerGuiPlugin) {
        super(I18n.tr((String)"JunctionChecking"), "junctionchecker", I18n.tr((String)"Open the junctionchecking window."), Shortcut.registerShortcut((String)"subwindow:junctionchecker", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"junctions")}), (int)66, (int)4, (int)1), 150);
        this.plugin = junctionCheckerGuiPlugin;
        JPanel digraphPanel = new JPanel(new GridLayout(1, 2));
        digraphPanel.setBorder(new TitledBorder(I18n.tr((String)"Channel-Digraph creation")));
        this.digraphsealcb = new JCheckBox(I18n.tr((String)"seal Channel Digraph"));
        this.digraphsealcb.setSelected(false);
        this.sccCB = new JCheckBox(I18n.tr((String)"calculate strong connected channels"));
        this.sccCB.setSelected(true);
        digraphPanel.add(this.sccCB);
        JPanel jcPanel = new JPanel(new GridLayout(4, 1));
        jcPanel.setBorder(new TitledBorder(I18n.tr((String)"Junctionchecking/junctions searching")));
        JPanel spinnerpanel = new JPanel(new GridLayout(1, 2));
        this.smodel = new SpinnerNumberModel(3, 1, 20, 1);
        this.nways = new JSpinner(this.smodel);
        this.nwayslabel = new JLabel(I18n.tr((String)"order of junction (n):"));
        this.nwayslabel.setEnabled(false);
        spinnerpanel.add(this.nwayslabel);
        spinnerpanel.add(this.nways);
        this.produceRelation = new JCheckBox(I18n.tr((String)"produce OSM-Relations: junction"));
        this.produceRelation.setToolTipText(I18n.tr((String)"if enabled the plugin produces osm-relations from the junction subgraphs"));
        this.produceRelation.setSelected(true);
        this.produceRelation.setEnabled(false);
        jcPanel.add(this.produceRelation);
        jcPanel.add(spinnerpanel);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.add(digraphPanel);
        centerPanel.add(jcPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3));
        this.createDigraphButton = new SideButton(I18n.marktr((String)"Create"), "digraphcreation", I18n.tr((String)"start the channel digraph creation"), I18n.tr((String)"create the channel digraph"), (ActionListener)this);
        buttonPanel.add((Component)this.createDigraphButton);
        this.checkJunctionButton = new SideButton(I18n.marktr((String)"Check "), "junctioncheck", I18n.tr((String)"check a marked subset if it is a junction"), I18n.tr((String)"check the subust for junction properties"), (ActionListener)this);
        this.checkJunctionButton.setEnabled(false);
        buttonPanel.add((Component)this.checkJunctionButton);
        this.searchJunctionButton = new SideButton(I18n.marktr((String)"Search "), "junctionsearch", I18n.tr((String)"search for junctions into a subset of channels"), I18n.tr((String)"search for junctions in the channel subset"), (ActionListener)this);
        this.searchJunctionButton.setEnabled(false);
        buttonPanel.add((Component)this.searchJunctionButton);
        this.add(centerPanel, "Center");
        this.add(buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("Create")) {
            DigraphCreationTask dct = new DigraphCreationTask(this.plugin, this.digraphsealcb.isSelected(), this.sccCB.isSelected());
            Main.worker.submit((Runnable)((Object)dct));
            this.setActivateJunctionCheckOrSearch(true);
        } else if (actionCommand.equals("Check ")) {
            PrepareJunctionCheckorSearch pjc = new PrepareJunctionCheckorSearch(this.plugin, this.smodel.getNumber().intValue(), this.produceRelation.isSelected());
            pjc.prepareJunctionCheck();
        } else if (actionCommand.equals("Search ")) {
            PrepareJunctionCheckorSearch pjc = new PrepareJunctionCheckorSearch(this.plugin, this.smodel.getNumber().intValue(), this.produceRelation.isSelected());
            pjc.prepareJunctionSearch();
        }
    }

    public void setActivateJunctionCheckOrSearch(boolean activate) {
        this.checkJunctionButton.setEnabled(activate);
        this.nways.setEnabled(activate);
        this.nwayslabel.setEnabled(activate);
        this.produceRelation.setEnabled(activate);
        this.searchJunctionButton.setEnabled(activate);
    }

    public void setActivateCreateDigraph(boolean activate) {
        this.createDigraphButton.setEnabled(activate);
        this.digraphsealcb.setEnabled(activate);
        this.sccCB.setEnabled(activate);
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
    }
}

