/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import livegps.LiveGpsLayer;

public class LiveGpsAcquirer
implements Runnable {
    LiveGpsLayer view;
    Socket gpsdSocket;
    BufferedReader gpsdReader;
    boolean connected = false;
    String gpsdHost = "localhost";
    int gpsdPort = 2947;
    boolean shutdownFlag = false;

    public void run() {
        while (!this.shutdownFlag) {
            double d = 0.0;
            double d2 = 0.0;
            boolean bl = false;
            try {
                InetAddress[] inetAddressArray;
                if (!this.connected) {
                    this.view.setStatus("connecting...");
                    inetAddressArray = InetAddress.getAllByName(this.gpsdHost);
                    for (int i = 0; i < inetAddressArray.length; ++i) {
                        try {
                            this.gpsdSocket = new Socket(inetAddressArray[i], this.gpsdPort);
                            break;
                        }
                        catch (Exception exception) {
                            this.gpsdSocket = null;
                            continue;
                        }
                    }
                    if (this.gpsdSocket != null) {
                        this.gpsdReader = new BufferedReader(new InputStreamReader(this.gpsdSocket.getInputStream()));
                        this.gpsdSocket.getOutputStream().write(new byte[]{119, 13, 10});
                    }
                    this.view.setStatus("connected");
                    this.connected = true;
                }
                if ((inetAddressArray = this.gpsdReader.readLine()) == null) break;
                String[] stringArray = inetAddressArray.split(",");
                if (stringArray.length == 0 || !stringArray[0].equals("GPSD")) continue;
                block16: for (int i = 1; i < stringArray.length; ++i) {
                    if (stringArray[i].length() < 2 || stringArray[i].charAt(1) != '=') continue;
                    char c = stringArray[i].charAt(0);
                    String string = stringArray[i].substring(2);
                    switch (c) {
                        case 'O': {
                            String[] stringArray2 = string.split("\\s+");
                            if (stringArray2.length < 5) continue block16;
                            d = Double.parseDouble(stringArray2[3]);
                            d2 = Double.parseDouble(stringArray2[4]);
                            try {
                                this.view.setSpeed(Float.parseFloat(stringArray2[9]));
                                this.view.setCourse(Float.parseFloat(stringArray2[8]));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            bl = true;
                            continue block16;
                        }
                        case 'P': {
                            String[] stringArray3 = string.split("\\s+");
                            if (stringArray3.length < 2) continue block16;
                            d = Double.parseDouble(stringArray3[0]);
                            d2 = Double.parseDouble(stringArray3[1]);
                            bl = true;
                        }
                    }
                }
                if (!bl) continue;
                this.view.setCurrentPosition(d, d2);
            }
            catch (IOException iOException) {
                this.connected = false;
                this.view.setStatus("connection failed");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        this.view.setStatus("disconnected");
        if (this.gpsdSocket != null) {
            try {
                this.gpsdSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void shutdown() {
        this.shutdownFlag = true;
    }

    public void setOutputLayer(LiveGpsLayer liveGpsLayer) {
        this.view = liveGpsLayer;
    }
}

